<table class="form-table">

    <?php

        $field->add('select',
            array(
                'label'    => esc_html__('Add Soical Media', 'wp-any-contact-us'),
                'id'       => 'wacu-admin-add-social-media',
                'select2'  => true,
                'selected' => '0',
                'option'   => array(
                    '0'            => esc_html__('Select Social Media', 'wp-any-contact-us'),
                    'fb_messenger' => esc_html__('Facebook Messenger', 'wp-any-contact-us'),
                    'instagram'    => esc_html__('Instagram', 'wp-any-contact-us'),
                    'linkedin'     => esc_html__('Linked In', 'wp-any-contact-us'),
                    'skype'        => esc_html__('Skype', 'wp-any-contact-us'),
                    'telegram'     => esc_html__('Telegram', 'wp-any-contact-us'),
                    'whatsapp'     => esc_html__('WhastApp', 'wp-any-contact-us'),
                    'vk'           => esc_html__('VK', 'wp-any-contact-us'),
                ),
            )
        );

    ?>

</table>

<table class="widefat fixed striped">
    <thead>
        <tr>
            <td><strong>#</strong></td>
            <td><strong><?php esc_html_e('Social Media', 'wp-any-contact-us');?></strong></td>
            <td><strong><?php esc_html_e('Action', 'wp-any-contact-us');?></strong></td>
        </tr>
    </thead>
    <tbody>

        <?php
            $sr = 1;
            foreach (get_option('wacu_social_media', array()) as $key => $social_media): ?>
                <tr>
                    <td><?php echo $sr; ?></td>
                    <td><?php echo wp_kses_post($social_media['icon']) . " " . esc_html($social_media['title']); ?></td>
                    <td>
                        <a href="javascript:void(0)" class="button button-secondary" data-wacu-edit-social-media="<?php echo esc_attr($key); ?>">
                            <?php esc_html_e('Edit', 'wp-any-contact-us')?>
                        </a>
                        <a href="<?php echo esc_url(admin_url("admin.php?page=wc-any-contact-us&tab=add-social-media&delete_social_media={$key}")); ?>" class="button button-secondary">
                            <?php esc_html_e('Delete', 'wp-any-contact-us')?>
                        </a>
                    </td>
                </tr>
        <?php
            $sr++;
            endforeach;
        ?>

    </tbody>
</table>

<div id="wacu_social_media_popup-overlay"></div>
<div id="wacu_social_media_popup">
    <div id="wacu_social_media_popup__header">
        <i class="wacu-fa wacu-fa-times"></i>
    </div>

    <!-- for ajax stuff -->
    <div id="wacu_social_media_popup__body"></div>
    <!-- .for ajax stuff -->

    <div id="wacu_social_media_popup__footer"></div>
</div>