<?php
// Preventing to direct access
defined('ABSPATH') OR die('Direct access not acceptable!');

if ( ! class_exists('WACU_Enqueue')) {

    class WACU_Enqueue {

        public function __construct() {

            add_action('wp_enqueue_scripts', array($this, 'public_enqueue'));
            add_action('wp_enqueue_scripts', array($this, 'public_inline_style'));
            add_action('admin_enqueue_scripts', array($this, 'admin_enqueue'));
            add_action('admin_enqueue_scripts', array($this, 'admin_inline_style'));

        }

        public function admin_enqueue($hook) {

            if ($this->is_my_admin_page($hook) != true) {
                return;
            }

            // Loading all WeCreativez core scripts for admin
            wp_enqueue_script('wecreativez-core-tooltip');
            wp_enqueue_script('wecreativez-core-select2');
            wp_enqueue_style('wecreativez-core-select2');

            wp_enqueue_style('wecreativez-core-style');
            wp_enqueue_script('wecreativez-core-script');

            // enqueue Fontawesome
            wp_enqueue_style('wacu-fontawesome-style', WACU_URL . 'assets/css/wacu-fonts.css', array(), '4.7.0');

            // Admin style
            wp_enqueue_style('wacu-admin-style', WACU_URL . 'assets/css/wacu-admin-style.css', array(), WACU_VERSION);
            // Admin Script
            wp_enqueue_script('wacu-admin-script', WACU_URL . 'assets/js/wacu-admin-script.js', array(), WACU_VERSION, true);
            wp_localize_script('wacu-admin-script', 'wacuAdminObj', array(
                'ajax_url' => admin_url('admin-ajax.php'),
            ));

        }

        public function admin_inline_style() {

            if (isset($_GET['page']) && $_GET['page'] != 'wc-any-contact-us') {
                return;
            }

            // Widget fonts
            $fonts = '
          @font-face {
            font-family: "wacu-fonts";
            src: url("' . WACU_URL . "assets/fonts/fontawesome-webfont.eot" . '?v=4.7.0");
            src: url("' . WACU_URL . "assets/fonts/fontawesome-webfont.eot" . '?#iefix&v=4.7.0") format("embedded-opentype"),
                 url("' . WACU_URL . "assets/fonts/fontawesome-webfont.woff2" . '?v=4.7.0") format("woff2"),
                 url("' . WACU_URL . "assets/fonts/fontawesome-webfont.woff" . '?v=4.7.0") format("woff"),
                 url("' . WACU_URL . "assets/fonts/fontawesome-webfont.ttf" . '?v=4.7.0") format("truetype"),
                 url("' . WACU_URL . "assets/fonts/fontawesome-webfont.svg" . '?v=4.7.0#fontawesomeregular") format("svg");
            font-weight: normal;
            font-style: normal;
          }';
            wp_add_inline_style('wacu-admin-style', $fonts);

        }

        public function public_enqueue() {

            $wacu_appearance        = get_option('wacu_appearance', array());
            $wacu_smart_popup       = get_option('wacu_smart_popup', array());
            $wacu_gdpr_setting      = get_option('wacu_gdpr_setting', array());
            $wacu_developer_setting = get_option('wacu_developer_setting', array());

            if ($wacu_developer_setting['enqueue_jquery'] == '1') {
                // jQuery
                wp_enqueue_script('wacu-jsCookie-script', WACU_URL . 'assets/libraries/jQuery/jquery-3.3.1.min.js', array(), '3.3.1', true);
            }

            // enqueue Fontawesome
            wp_enqueue_style('wacu-fontawesome-style', WACU_URL . 'assets/css/wacu-fonts.css', array(), '4.7.0');

            // jSCookie
            wp_enqueue_script('wacu-jsCookie-script', WACU_URL . 'assets/libraries/jsCookie/js.cookie.js', array(), '2.2.0', true);

            // Public style
            wp_enqueue_style('wacu-public-style', WACU_URL . 'assets/css/wacu-public-style.css', array(), WACU_VERSION);
            // Public Script
            wp_enqueue_script('wacu-public-script', WACU_URL . 'assets/js/wacu-public-script.js', array(), WACU_VERSION, true);
            wp_localize_script('wacu-public-script', 'wacuPublicObj', array(
                'ajax_url'             => admin_url('admin-ajax.php'),
                'button_icon'          => $wacu_appearance['button_icon'],
                'smart_popup_interval' => $wacu_smart_popup['popup_interval'],
                'smart_popup_after'    => $wacu_smart_popup['popup_after'],
                'is_gdpr'              => $wacu_gdpr_setting['is_gdpr'],
            ));
        }

        public function public_inline_style() {
            $wacu_appearance    = get_option('wacu_appearance');
            $wacu_basic_setting = get_option('wacu_basic_setting', array());

            // Widget fonts
            $fonts = '@font-face {
                font-family: "wacu-fonts";
                src: url("' . WACU_URL . "assets/fonts/fontawesome-webfont.eot" . '?v=4.7.0");
                src: url("' . WACU_URL . "assets/fonts/fontawesome-webfont.eot" . '?#iefix&v=4.7.0") format("embedded-opentype"),
                     url("' . WACU_URL . "assets/fonts/fontawesome-webfont.woff2" . '?v=4.7.0") format("woff2"),
                     url("' . WACU_URL . "assets/fonts/fontawesome-webfont.woff" . '?v=4.7.0") format("woff"),
                     url("' . WACU_URL . "assets/fonts/fontawesome-webfont.ttf" . '?v=4.7.0") format("truetype"),
                     url("' . WACU_URL . "assets/fonts/fontawesome-webfont.svg" . '?v=4.7.0#fontawesomeregular") format("svg");
                font-weight: normal;
                font-style: normal;
              }';
            wp_add_inline_style('wacu-public-style', $fonts);

            // Custom text and backgroundcolor
            $custom_colors = '.wacu-bg-color {
                background-color: ' . esc_html($wacu_appearance['bg_color']) . ' !important;
              }
              .wacu-text-color {
                color: ' . $wacu_appearance['text_color'] . ' !important;
              }';
            wp_add_inline_style('wacu-public-style', $custom_colors);

            // custom widget location
            if ($wacu_appearance['location'] == 'br') {
                $container_location = '#wacu-popup-container {
                  bottom: ' . esc_html($wacu_appearance['button_offset']) . 'px;
                  right: ' . esc_html($wacu_appearance['button_offset']) . 'px;
                  align-items: flex-end;
                }
                #wacu-popup-container .wacu-footer .wacu-tirgger-message,
                #wacu-popup-container .wacu-footer .wacu-tirgger-message .wacu-tirgger-message--close  {
                  right: 0;
                }';
                wp_add_inline_style('wacu-public-style', $container_location);
            }

            if ($wacu_appearance['location'] == 'bl') {
                $container_location = '#wacu-popup-container {
                  bottom: ' . esc_html($wacu_appearance['button_offset']) . 'px;
                  left: ' . esc_html($wacu_appearance['button_offset']) . 'px;
                  align-items: flex-start;
                }
                #wacu-popup-container .wacu-footer .wacu-tirgger-message,
                #wacu-popup-container .wacu-footer .wacu-tirgger-message .wacu-tirgger-message--close {
                  left: 0;
                }';
                wp_add_inline_style('wacu-public-style', $container_location);
            }

            // RTL custom CSS
            if ($wacu_appearance['rtl'] == '1') {
                $rtl_css = '#wacu-popup-main, .wacu-tirgger-message {
                  direction: rtl;
                }
                #wacu-popup-container .wacu-popup .wacu-popup__body ul.wacu-contact-media li i {
                  margin-left: 10px !important;
                }';
                wp_add_inline_style('wacu-public-style', $rtl_css);
            }

            // Widget button custom CSS
            $button_color = '#wacu-popup-container input[type=submit] {
                background: ' . esc_html($wacu_appearance['bg_color']) . ' !important;
                color: ' . esc_html($wacu_appearance['text_color']) . ' !important;
                border: 1px solid ' . esc_html($wacu_appearance['bg_color']) . ' !important;
              }';
            wp_add_inline_style('wacu-public-style', $button_color);

            // User Custom CSS
            wp_add_inline_style('wacu-public-style', $wacu_basic_setting['custom_css']);

        }

        /**
         * This method is for checking current admin page is this plugin page or not
         * @param  string  $hook Current admin page slug
         * @return boolean
         * @since 1.0
         */
        private function is_my_admin_page($hook) {

            if ($hook == 'toplevel_page_wc-any-contact-us'
                || $hook == 'wp-any-contact-us_page_wc-any-contact-us-gdpr') {

                return true;

            }

            return false;

        }

    } // .WACU_Enqueue

    new WACU_Enqueue;

}