<?php

// Preventing to direct access
defined('ABSPATH') OR die('Direct access not acceptable!');

if ( ! class_exists('WACU_Admin_Save_Setting')):

    class WACU_Admin_Save_Setting {

        public function __construct() {

            add_action('admin_init', array($this, 'save_appearance'));
            add_action('admin_init', array($this, 'basic_setting'));
            add_action('admin_init', array($this, 'contact_medium'));
            add_action('admin_init', array($this, 'smart_popup'));
            add_action('admin_init', array($this, 'developer_setting'));
            add_action('admin_init', array($this, 'add_social_media'));
            add_action('admin_init', array($this, 'gdpr_setting'));

            add_action('admin_init', array($this, 'delete_social_media'));
            add_action('admin_init', array($this, 'admin_review'));

            add_action('admin_init', array($this, 'license_key_deactivate'));

        }

        /**
         * Appearance setting save
         * @since 1.0
         */
        public function save_appearance() {

            if ( ! isset($_POST['wacu_appearance_submit'])) {
                return;
            }

            $post_data = stripslashes_deep( $_POST['wacu_appearance'] );

            $appearance = array(
                'bg_color'      => sanitize_text_field($post_data['bg_color']),
                'text_color'    => sanitize_text_field($post_data['text_color']),
                'location'      => sanitize_text_field($post_data['location']),
                'rtl'           => (isset($post_data['rtl'])) ? '1' : '0',
                'button_offset' => sanitize_text_field($post_data['button_offset']),
                'button_icon'   => sanitize_text_field($post_data['button_icon']),
                'header_text'   => sanitize_text_field($post_data['header_text']),
            );

            update_option('wacu_appearance', $appearance);

        }

        /**
         * Basic setting save
         * @since 1.0
         */
        public function basic_setting() {

            if ( ! isset($_POST['wacu_basic_setting_submit'])) {
                return;
            }

            $post_data = stripslashes_deep( $_POST['wacu_basic_setting'] );

            $basic_setting = array(
                'contact'    => array(
                    'email'           => (isset($post_data['contact']['email'])) ? '1' : '0',
                    'schedule_a_call' => (isset($post_data['contact']['schedule_a_call'])) ? '1' : '0',
                ),
                'custom_css' => $post_data['custom_css'],
            );

            update_option('wacu_basic_setting', $basic_setting);

        }

        public function contact_medium() {

            if ( ! isset($_POST['wacu_contact_medium_submit'])) {
                return;
            }

            $post_data = stripslashes_deep( $_POST['wacu_contact_medium'] );

            $contact_medium = get_option('wacu_contact_medium', array());

            if (isset($post_data['schedule_a_call'])) {
                $contact_medium['schedule_a_call'] = array(
                    'label'             => array(
                        'full_name'       => sanitize_text_field($post_data['schedule_a_call']['label']['full_name']),
                        'country'         => sanitize_text_field($post_data['schedule_a_call']['label']['country']),
                        'callback_number' => sanitize_text_field($post_data['schedule_a_call']['label']['callback_number']),
                        'schedule_time'   => sanitize_text_field($post_data['schedule_a_call']['label']['schedule_time']),
                        'button'          => sanitize_text_field($post_data['schedule_a_call']['label']['button']),
                        'label'           => sanitize_text_field($post_data['schedule_a_call']['label']['label']),
                    ),
                    'email'             => array(
                        'subject' => sanitize_text_field($post_data['schedule_a_call']['email']['subject']),
                        'body'    => $post_data['schedule_a_call']['email']['body'],
                        'to'      => $post_data['schedule_a_call']['email']['to'],
                    ),
                    'thank_you_message' => $post_data['schedule_a_call']['thank_you_message'],
                    'desc'              => sanitize_text_field($post_data['schedule_a_call']['desc']),
                );
            }

            if (isset($post_data['email'])) {
                $contact_medium['email'] = array(
                    'label'             => array(
                        'full_name'     => sanitize_text_field($post_data['email']['label']['full_name']),
                        'email_address' => sanitize_text_field($post_data['email']['label']['email_address']),
                        'message'       => sanitize_text_field($post_data['email']['label']['message']),
                        'label'         => sanitize_text_field($post_data['email']['label']['label']),
                        'button'        => sanitize_text_field($post_data['email']['label']['button']),
                    ),
                    'email'             => array(
                        'subject' => sanitize_text_field($post_data['email']['email']['subject']),
                        'body'    => $post_data['email']['email']['body'],
                        'to'      => $post_data['email']['email']['to'],
                    ),
                    'thank_you_message' => $post_data['email']['thank_you_message'],
                    'desc'              => sanitize_text_field($post_data['email']['desc']),
                );
            }

            update_option('wacu_contact_medium', $contact_medium);

        }

        /**
         * Smart popup settings save
         * @since 1.0
         */
        public function smart_popup() {

            if ( ! isset($_POST['wacu_smart_popup_submit'])) {
                return;
            }

            $post_data = stripslashes_deep( $_POST['wacu_smart_popup'] );

            $smart_popup = array(
                'text'           => array(
                    'default'     => $post_data['text']['default'],
                    'woo_product' => $post_data['text']['woo_product'],
                ),
                'popup_interval' => sanitize_text_field($post_data['popup_interval']),
                'popup_after'    => sanitize_text_field($post_data['popup_after']),
                'is_popup'       => (isset($post_data['is_popup'])) ? '1' : '0',
            );

            update_option('wacu_smart_popup', $smart_popup);

        }

        /**
         * Developer settings save
         * @since 1.0
         */
        public function developer_setting() {

            if ( ! isset($_POST['wacu_developer_setting_submit'])) {
                return;
            }

            $developer_setting = array(
                'is_remove_everything' => (isset($_POST['wacu_developer_setting']['is_remove_everything'])) ? '1' : '0',
                'enqueue_jquery'       => (isset($_POST['wacu_developer_setting']['enqueue_jquery'])) ? '1' : '0',
            );

            update_option('wacu_developer_setting', $developer_setting);
        }

        /**
         * Add and Edit social media channels
         * @since 1.0
         */
        public function add_social_media() {

            // If post is not set then return
            if ( ! isset($_POST['wacu_social_media_submit'])) {
                return;
            }

            // Get data from form (POST)
            $post_data = stripslashes_deep( $_POST['wacu_social_media'] );

            // Get social media key for edit from edit popup
            $social_media_edit_key = (isset($_POST['wacu_social_media_edit_key'])) ? $_POST['wacu_social_media_edit_key'] : null;

            // Default array
            $data = array(
                'number'       => (isset($post_data['number'])) ? $post_data['number'] : '',
                'username'     => (isset($post_data['username'])) ? $post_data['username'] : '',
                'social_media' => (isset($post_data['social_media'])) ? $post_data['social_media'] : '',
                'title'        => (isset($post_data['title'])) ? $post_data['title'] : '',
                'link'         => (isset($post_data['link'])) ? $post_data['link'] : '',
                'icon'         => (isset($post_data['icon'])) ? $post_data['icon'] : '',
                'desc'         => (isset($post_data['desc'])) ? $post_data['desc'] : '',
            );

            // Social media Links and icons
            $social_media_detail = array(
                'whatsapp'     => array(
                    'link' => "https://api.whatsapp.com/send?phone={$data['number']}",
                    'icon' => '<i class="wacu-fa wacu-fa-whatsapp" style="color: #25D366"></i>',
                ),
                'skype'        => array(
                    'link' => "skype://{$data['username']}?chat",
                    'icon' => '<i class="wacu-fa wacu-fa-skype" style="color: #00AFF0"></i>',
                ),
                'instagram'    => array(
                    'link' => "https://instagram.com/{$data['username']}",
                    'icon' => '<i class="wacu-fa wacu-fa-instagram" style="color: #e4405f"></i>',
                ),
                'fb_messenger' => array(
                    'link' => "https://m.me/{$data['username']}",
                    'icon' => '<i class="wacu-fa wacu-fa-comments" style="color: #0084FF"></i>',
                ),
                'telegram'     => array(
                    'link' => "https://t.me/{$data['username']}",
                    'icon' => '<i class="wacu-fa wacu-fa-telegram" style="color: #39AFE2"></i>',
                ),
                'linkedin'     => array(
                    'link' => "https://www.linkedin.com/in/{$data['username']}",
                    'icon' => '<i class="wacu-fa wacu-fa-linkedin" style="color: #0077B5"></i>',
                ),
                'vk'     => array(
                    'link' => "https://vk.com/{$data['username']}",
                    'icon' => '<i class="wacu-fa wacu-fa-vk" style="color: #4c75a3"></i>',
                ),
            );

            // Get stored options from database
            $add_social_media  = get_option('wacu_social_media', array());
            $edit_social_media = get_option('wacu_social_media', array());

            // Add data into aray
            $add_social_media[] = array(
                'social_media' => $data['social_media'],
                'title'        => $data['title'],
                'desc'         => $data['desc'],
                'username'     => $data['username'],
                'number'       => $data['number'],
                'link'         => $social_media_detail[$data['social_media']]['link'],
                'icon'         => $social_media_detail[$data['social_media']]['icon'],
            );

            // Edit data into aray
            $edit_social_media[$social_media_edit_key] = array(
                'social_media' => $data['social_media'],
                'title'        => $data['title'],
                'desc'         => $data['desc'],
                'username'     => $data['username'],
                'number'       => $data['number'],
                'link'         => $social_media_detail[$data['social_media']]['link'],
                'icon'         => $social_media_detail[$data['social_media']]['icon'],
            );

            // Update option
            if ($social_media_edit_key != null) {
                update_option('wacu_social_media', $edit_social_media);
            } else {
                update_option('wacu_social_media', $add_social_media);
            }

        }

        /**
         * Delete added social media channel
         * @since 1.0
         */
        public function delete_social_media() {

            // If delete not applied then return
            if (isset($_GET['page']) && $_GET['page'] == "wc-any-contact-us" && isset($_GET['delete_social_media'])) {

                // Get the options
                $add_social_media = get_option('wacu_social_media', array());

                // unset the social media
                unset($add_social_media[$_GET['delete_social_media']]);

                // Update option
                update_option('wacu_social_media', $add_social_media);

                // Redirect to admin page
                wp_redirect(admin_url('admin.php?page=wc-any-contact-us&tab=add-social-media'));

            }

        }

        /**
         * GDPR save settings
         * @since 1.0
         */
        public function gdpr_setting() {

            if ( ! isset($_POST['wacu_gdpr_setting_submit'])) {
                return;
            }

            $wacu_gdpr_setting = get_option('wacu_gdpr_setting', array());

            $post_data = stripslashes_deep( $_POST['wacu_gdpr_setting'] );

            $wacu_gdpr_setting = array(
                'is_gdpr'      => (isset($_POST['wacu_gdpr_setting']['is_gdpr'])) ? '1' : '0',
                'message'      => $post_data['message'],
                'privacy_page' => $post_data['privacy_page'],
            );

            update_option('wacu_gdpr_setting', $wacu_gdpr_setting);

        }

        /**
         * Admin plugin review
         * If admin cancel review or already submit review
         * @since 1.0
         */
        public function admin_review() {

            if ( ! isset($_GET['wacu_admin_review'])) {
                return;
            }

            update_option('wacu_admin_review', '1');

            wp_redirect(admin_url('admin.php?page=wc-any-contact-us'));

        }

        /**
         * Plugin license key deactivation
         * @since 1.0
         */
        public function license_key_deactivate() {

            if ( ! isset($_POST['wacu_license_key_deactivate'])) {
                return;
            }

            delete_option('wacu_license_key');

            wp_redirect(admin_url('admin.php?page=wc-any-contact-us'));

        }

    } // end WACU_Admin_Save_Setting

    new WACU_Admin_Save_Setting;

endif;