<?php
// Preventing to direct access
defined('ABSPATH') OR die('Direct access not acceptable!');

if ( ! class_exists('WACU_Admin_Menu')) {

    class WACU_Admin_Menu {

        public function __construct() {

            add_action('admin_menu', array($this, 'add_admin_menu'));

        } // .__construct()

        /**
         * Add admin menus
         * @since 1.0
         */
        public function add_admin_menu() {

            if (get_option('wacu_license_key') == '') {

                add_menu_page(
                    esc_html__('WP Any Contact Us', 'wp-any-contact-us'),
                    esc_html__('WP Any Contact Us', 'wp-any-contact-us'),
                    'manage_options',
                    'wc-any-contact-us',
                    array($this, 'plugin_activation'),
                    'dashicons-phone'
                );

            } else {

                add_menu_page(
                    esc_html__('WP Any Contact Us', 'wp-any-contact-us'),
                    esc_html__('WP Any Contact Us', 'wp-any-contact-us'),
                    'manage_options',
                    'wc-any-contact-us',
                    array($this, 'admin_page'),
                    'dashicons-phone'
                );

                add_submenu_page(
                    'wc-any-contact-us',
                    esc_html__('GDPR Setting', 'wp-any-contact-us'),
                    esc_html__('GDPR Setting', 'wp-any-contact-us'),
                    'manage_options',
                    'wc-any-contact-us-gdpr',
                    array($this, 'gdpr_setting')
                );

            }

            add_submenu_page(
                'wc-any-contact-us',
                esc_html__('Plugin Support', 'wp-any-contact-us'),
                esc_html__('Plugin Support', 'wp-any-contact-us'),
                'manage_options',
                'wc-any-contact-us-plugin-support',
                array($this, 'plugin_support')
            );

        }

        public function admin_page() {
            require_once WACU_PATH . 'views/admin/admin-page.php';
        }

        public function plugin_support() {
            require_once WACU_PATH . 'views/admin/admin-plugin-support.php';
        }

        public function gdpr_setting() {

            $field             = new Wecreativez_Core_Field;
            $wacu_gdpr_setting = get_option('wacu_gdpr_setting', array());

            require_once WACU_PATH . 'views/admin/admin-gdpr-setting.php';
        }

        public function plugin_activation() {
            require_once WACU_PATH . 'views/admin/admin-plugin-activation.php';
        }

    } // .WACU_Admin_Menu

    new WACU_Admin_Menu;

}
