<?php

// Preventing to direct access
defined('ABSPATH') OR die('Direct access not acceptable!');

class WACU_Admin_Ajax {

    public function __construct() {

        add_action("wp_ajax_wacu_social_media_ajax", array($this, 'social_media_ajax'));
        add_action("wp_ajax_nopriv_wacu_social_media_ajax", array($this, 'social_media_ajax'));

        add_action("wp_ajax_wacu_plugin_activation_ajax", array($this, 'plugin_activation_ajax'));
        add_action("wp_ajax_nopriv_wacu_plugin_activation_ajax", array($this, 'plugin_activation_ajax'));

    }

    public function social_media_ajax() {

        $social_media = $_POST['social_media'];

        if (isset($_POST['edit_social_media'])) {
            $social_media_db   = get_option('wacu_social_media', array());
            $social_media_edit = $social_media_db[$_POST['edit_social_media']];
            $social_media      = $social_media_edit['social_media'];
        }

        if ($social_media == '0') {
            return;
        }

        $field = new Wecreativez_Core_Field;

        $social_media_with_username = array('fb_messenger', 'instagram', 'telegram', 'skype', 'linkedin', 'vk');

        echo '<form action="#" method="post">';
        echo '<table class="form-table">';

        echo "<input type='hidden' name='wacu_social_media[social_media]' value='" . esc_attr($social_media) . "'>";
        echo "<input type='hidden' name='wacu_social_media_edit_key' value='" . esc_attr($_POST['edit_social_media']) . "'>";

        // Title
        $field->add('text',
            array(
                'label'    => esc_html__('Title', 'wp-any-contact-us'),
                'name'     => 'wacu_social_media[title]',
                'value'    => esc_attr($social_media_edit['title']),
                'desc'     => esc_html__('Required: Enter the title of Social Media.', 'wp-any-contact-us'),
                'required' => true,
            )
        );

        // Desc
        $field->add('text',
            array(
                'label' => esc_html__('Description', 'wp-any-contact-us'),
                'name'  => 'wacu_social_media[desc]',
                'value' => esc_attr($social_media_edit['desc']),
                'desc'  => esc_html__('Optional: Enter the description.', 'wp-any-contact-us'),
            )
        );

        if (in_array($social_media, $social_media_with_username)):

            // Username
            $field->add('text',
                array(
                    'label'    => esc_html__('Username', 'wp-any-contact-us'),
                    'name'     => 'wacu_social_media[username]',
                    'value'    => esc_attr($social_media_edit['username']),
                    'desc'     => esc_html__('Required: Enter the social media username.', 'wp-any-contact-us'),
                    'required' => true,
                )
            );

        endif;

        // Whatsapp
        if ($social_media == 'whatsapp'):

            // Number
            $field->add('number',
                array(
                    'label'    => esc_html__('Number', 'wp-any-contact-us'),
                    'name'     => 'wacu_social_media[number]',
                    'value'    => esc_attr($social_media_edit['number']),
                    'desc'     => esc_html__('Enter mobile phone number with the international country code, without + character. Example:  911234567890 for (+91) 1234567890.', 'wp-any-contact-us'),
                    'required' => true,
                    'step'     => '1',
                    'min'      => '1',
                )
            );

        endif;

        echo '</table>';

        submit_button(esc_attr__('Add Social Media', 'wp-any-contact-us'), 'primary', 'wacu_social_media_submit');

        echo '</form>';

        wp_die();
    }

    /**
     * Plugin activation process
     * @since 1.0
     */
    public function plugin_activation_ajax() {

        $license_key = trim($_POST['purchase_code']);

        $params = array(
            'body' => array(
                'license_user' => site_url(),
                'license_key'  => $license_key,
            ),
        );

        // Make the POST request
        $request = wp_remote_post('http://envato.wecreativez.com/plugin-verification/wordpress-any-contact-us', $params);

        // Check if response is valid
        if ( ! is_wp_error($request) || wp_remote_retrieve_response_code($request) === 200) {

            $response = json_decode($request['body']);

            if ($response->flag == '0') {
                update_option('wacu_license_key', $license_key);
                echo '<div> ' . esc_html__('Plugin Activated', 'wp-any-contact-us') . ' </div>';
                echo '<div><a  href="' . esc_url(admin_url('admin.php?page=wc-any-contact-us')) . '">' . esc_html__('Goto Plugin Settings', 'wp-any-contact-us') . '<a/></div>';
            } else {
                update_option('wacu_license_key', '');
                esc_html_e('Invalid Purchase Code', 'wp-any-contact-us');
            }

        } else {

            esc_html_e('Server error. Please contact plugin author.', 'wp-any-contact-us');

        }

        wp_die();
    }

}

new WACU_Admin_Ajax;