<?php
// Preventing to direct access
defined('ABSPATH') OR die('Direct access not acceptable!');

if ( ! class_exists('WACU_Activation')) {

    class WACU_Activation {

        /**
         * Plugin activation method
         * @since 1.0
         */
        public static function activate() {

            Wecreativez_Core_Register_Setting::register('wacu_appearance',
                array(
                    'bg_color'      => '#606ccb',
                    'text_color'    => '#fff',
                    'location'      => 'br',
                    'rtl'           => '0',
                    'button_icon'   => 'wacu-fa wacu-fa-comments',
                    'button_offset' => '16',
                    'header_text'   => 'How would like to contact us?',
                )
            );

            Wecreativez_Core_Register_Setting::register('wacu_basic_setting',
                array(
                    'contact'    => array(
                        'email'           => '1',
                        'schedule_a_call' => '1',
                        'whatsapp'        => '1',
                        'skype'           => '1',
                        'messenger'       => '1',
                        'telegram'        => '1',
                    ),
                    'custom_css' => '',
                )
            );

            Wecreativez_Core_Register_Setting::register('wacu_smart_popup',
                array(
                    'text'           => array(
                        'default'     => '🙏 Welcome to <strong>' . get_option('blogname') . '!</strong><br />How can we help?',
                        'woo_product' => '🙋‍♂️ Need help in buying <strong>{{product_name}}</strong>? Please contact us now.',
                    ),
                    'popup_interval' => '300',
                    'popup_after'    => '5',
                    'is_popup'       => '1',
                )
            );

            Wecreativez_Core_Register_Setting::register('wacu_contact_medium',
                array(
                    'schedule_a_call' => array(
                        'desc'              => 'We will call you on scheduled time',
                        'label'             => array(
                            'full_name'       => 'Enter your full name',
                            'country'         => 'Select country',
                            'callback_number' => 'Enter callback number',
                            'schedule_time'   => 'Choose schedule time',
                            'button'          => 'Schedule a Call',
                            'label'           => 'Schedule a call',
                        ),
                        'email'             => array(
                            'subject' => 'Schedule a call request - {{name}}',
                            'body'    => '<p>You received a new callback request<br />Details are following:<br /><strong>Name:</strong> {{name}}<br /><strong>Country:</strong> {{country}}<br /><strong>Callback Number:</strong> {{callback_number}}<br /><strong>Callback Time:</strong> {{callback_time}}</p>',
                            'to'      => get_option('admin_email'),
                        ),
                        'thank_you_message' => '<h4 style="text-align: center;">Thank you, {{name}},</h4><p style="text-align: center;">We will contact you shortly.</p>',
                    ),
                    'email'           => array(
                        'desc'              => 'Usual reply in 2 hours',
                        'label'             => array(
                            'full_name'     => 'Enter your full name',
                            'email_address' => 'Enter your email address',
                            'message'       => 'Enter message',
                            'label'         => 'Email',
                            'button'        => 'Send Email',
                        ),
                        'email'             => array(
                            'subject' => 'New email request - {{name}}',
                            'body'    => '<p>You received a new email request<br />Details are following:<br /><strong>Name:</strong> {{name}}<br /><strong>Email:</strong> {{email}}<br /><strong>Message:</strong> {{message}}</p>',
                            'to'      => get_option('admin_email'),
                        ),
                        'thank_you_message' => '<h4 style="text-align: center;">Thank you, {{name}},</h4><p style="text-align: center;">We will contact you shortly.</p>',
                    ),
                )
            );

            Wecreativez_Core_Register_Setting::register('wacu_social_media', array());

            Wecreativez_Core_Register_Setting::register('wacu_developer_setting',
                array(
                    'is_remove_everything' => '0',
                    'enqueue_jquery'       => '0',
                )
            );

            Wecreativez_Core_Register_Setting::register('wacu_gdpr_setting',
                array(
                    'is_gdpr'      => '0',
                    'message'      => 'I agree to all the {{privacy_page}}',
                    'privacy_page' => get_option('page_on_front'),
                )
            );

        }

    }

} // .WACU_Activation