(function($) { 
"use strict"; 

	// Display add social media popup
	jQuery( document ).on('change', '#wacu-admin-add-social-media', function(event) {
		event.preventDefault();
		
		var socialMedia = jQuery(this).val();

		jQuery( '#wacu_social_media_popup-overlay, #wacu_social_media_popup' ).show();
		jQuery( '#wacu_social_media_popup__body' ).empty();

		jQuery.ajax({
			url: wacuAdminObj.ajax_url,
			type: 'POST',
			data: {
				'action': 'wacu_social_media_ajax',
				'social_media': socialMedia,
			},
		})
		.done(function( response ) {
			jQuery( '#wacu_social_media_popup__body' ).html( response );
		});
		
	});


	// Edit social media 
	jQuery( document ).on('click', '[data-wacu-edit-social-media]', function(event) {
		event.preventDefault();
		
		var socialMedia = jQuery(this).attr( 'data-wacu-edit-social-media' );

		jQuery( '#wacu_social_media_popup-overlay, #wacu_social_media_popup' ).show();

		jQuery.ajax({
			url: wacuAdminObj.ajax_url,
			type: 'POST',
			data: {
				'action': 'wacu_social_media_ajax',
				'edit_social_media': socialMedia,
			},
		})
		.done(function( response ) {
			jQuery( '#wacu_social_media_popup__body' ).html( response );
		});
		
	});


	// Close add social media popup
	jQuery( document ).on('click', '#wacu_social_media_popup__header .wacu-fa-times, #wacu_social_media_popup-overlay', function(event) {
		event.preventDefault();
		jQuery( '#wacu_social_media_popup-overlay, #wacu_social_media_popup' ).hide();
	});


	// Plugin license submission
	jQuery( '#wacu-license-form' ).on('submit', function(event) {
		event.preventDefault();

		jQuery( '#wacu-plugin-activation form' ).hide();
		jQuery( '#wacu-plugin-activation h5' ).show();
		
		var user 	= jQuery( '[name="wacu_license[user]"]' ).val(); 
		var key 	= jQuery( '[name="wacu_license[key]"' ).val();

		$.ajax({
			url: wacuAdminObj.ajax_url,
			type: 'post',
			data: {
				'action': 'wacu_plugin_activation_ajax',
				'purchase_code': key,
			},
		})
		.done(function( response ) {
			jQuery( '#wacu-plugin-activation-message' ).html( response );
			jQuery( '#wacu-plugin-activation-message ' ).show();
			jQuery( '#wacu-plugin-activation form' ).show();
			jQuery( '#wacu-plugin-activation h5' ).hide();
		});

	});

})(jQuery);
