<?php

/**
 * The plugin bootstrap file
 *
 *
 * @link              http://plugins.db-dzine.com
 * @since             1.0.0
 * @package           WooCommerce_Quick_Order
 *
 * @wordpress-plugin
 * Plugin Name:       WooCommerce Quick Order
 * Plugin URI:        http://plugins.db-dzine.com
 * Description:       Add a quick order functionality to your WooCommerce Shop
 * Version:           1.0.3
 * Author:            اسکریپت دات کام
 * Author URI:        http://www.اسکریپت.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       woocommerce-quick-order
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-woocommerce-quick-order-activator.php
 */
function activate_woocommerce_quick_order() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-woocommerce-quick-order-activator.php';
	WooCommerce_Quick_Order_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-woocommerce-quick-order-deactivator.php
 */
function deactivate_woocommerce_quick_order() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-woocommerce-quick-order-deactivator.php';
	WooCommerce_Quick_Order_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_woocommerce_quick_order' );
register_deactivation_hook( __FILE__, 'deactivate_woocommerce_quick_order' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-woocommerce-quick-order.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_woocommerce_quick_order() {

	$plugin_data = get_plugin_data( __FILE__ );
	$version = $plugin_data['Version'];

	$plugin = new WooCommerce_Quick_Order($version);
	$plugin->run();

	return $plugin;

}

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

if ( is_plugin_active( 'woocommerce/woocommerce.php') && is_plugin_active('redux-framework/redux-framework.php') ){
	$WooCommerce_Quick_Order = run_woocommerce_quick_order();
} else {
	add_action( 'admin_notices', 'woocommerce_quick_order_installed_notice' );
}

function woocommerce_quick_order_installed_notice()
{
	?>
    <div class="error notice-warning settings-error notice is-dismissible">
      <p><?php _e( 'WooCommerce Quick Order requires the WooCommerce & Redux Framework plugin. Please install or activate them before!', 'woocommerce-quick-order'); ?></p>
      <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
    </div>
    <?php
}