(function( $ ) {
	'use strict';

	// Create the defaults once
	var pluginName = "quickOrder",
		defaults = {
			'btnText' : 'Quick View',
			'modalHeightAuto' : '1',
		};

	// The actual plugin constructor
	function Plugin ( element, options ) {
		this.element = element;
		
		this.settings = $.extend( {}, defaults, options );
		this._defaults = defaults;
		this.trans = this.settings.trans;
		this._name = pluginName;
		this.init();
	}

	// Avoid Plugin.prototype conflicts
	$.extend( Plugin.prototype, {
		init: function() {
			this.window = $(window);
			this.documentHeight = $( document ).height();
			this.windowHeight = this.window.height();
			this.product = {};
			this.elements = {};

			this.elements.quickOrderTable = $('#woocommerce-quick-order.datatables');
			this.elements.quickOrderSearch = $('#woocommerce-quick-order-search tbody');

			this.quickOrderTable();
			this.quickOrderSearch();
		},
		quickOrderTable : function() {

			var that = this;
			
			if(that.elements.quickOrderTable.length < 1) {
				return false;
			}
			var options = that.elements.quickOrderTable.data('options');

			$.each(options.buttons, function(i, index) {
				options.buttons[i].exportOptions = {
	                format: {
	                    header: function ( data, row, column, node ) {
	                        var newdata = data;
	                        // newdata = newdata.replace(/<[^>]*>/gi, '');
	                          var dummyDiv =  document.createElement( "div" );
							  dummyDiv.innerHTML = newdata;
							  // return Array.from( dummyDiv.childNodes ).filter( s => s.nodeType == 3 ).map( s => s.nodeValue ).join("");
							  return Array.from( dummyDiv.childNodes ).filter( function(s) { return s.nodeType === 3; } ).map( function(s) { return s.nodeValue; } ).join("");
	                        return newdata;
	                    }
	                }
	            }
			});

			if(options.filtering == "1") {
				options.initComplete = function () {
		            this.api().columns().every( function () {
		                var column = this;
		                var header = $(column.header());

		                if(header[0].id == "quick-order-table-header-im" || header[0].id == "quick-order-table-header-ca" || header[0].id == "quick-order-table-header-rm" || header[0].id == "quick-order-table-header-mc") {
		                	return;
		                }
		                var select = $('<select><option value="">' + that.trans.showAll + '</option></select>')
		                    .appendTo( $(column.header()) )
		                    .on( 'change', function () {
		                        var val = $.fn.dataTable.util.escapeRegex(
		                            $(this).val()
		                        );
		 
		                        column
		                            .search( val ? '^'+val+'$' : '', true, false )
		                            .draw();
		                    } );

							column.data().unique().sort().each( function ( d, j ) {
								var d = d.replace(/<(?:.|\n)*?>/gm, '');
							    if(column.search() === '^'+d+'$'){
							        select.append( '<option value="' + d + '" selected="selected">'+d+'</option>' )
							    } else {
							        select.append( '<option value="' + d + '">' + d + '</option>' )
							    }
							} );
		            } );
		        };
	        }
			that.elements.quickOrderTable.DataTable(options);

			that.quickOrderTableMultipleAddToCart();
		},
		quickOrderTableMultipleAddToCart : function() {

			var that = this;

			var quickOrderTableMultipleAddToCart = $('#quick-order-table-multiple-add-to-cart-btn');
			var quickOrderTableMultipleAddToCartProducts = $('.quick-order-table-multiple-add-to-cart-products');

			if ( quickOrderTableMultipleAddToCart.length < 1 ) {
				return false;
			}

			// Enable / Disable Button when checkbox checked
			that.elements.quickOrderTable.on('change', quickOrderTableMultipleAddToCartProducts, function(e) {
				var somethingChecked = false;

				$('.quick-order-table-multiple-add-to-cart-products').each(function(i, index) {

					if($(this).is(':checked')) {
						somethingChecked = true;
					}
				});
				if(somethingChecked) {
					quickOrderTableMultipleAddToCart.prop("disabled", false); 
				} else {
					quickOrderTableMultipleAddToCart.prop("disabled", true); 
				}
			});

			// Multiple Variations add to Cart
			quickOrderTableMultipleAddToCart.on('click', function(e) {
				e.preventDefault();

				var $thisbutton = $(this);
				$thisbutton.removeClass( 'added' );
				$thisbutton.addClass( 'loading' );

				var data = {
					'action' : 'woocommerce_quick_order_add_to_cart',
					'products' : [],
				};

				$('.quick-order-table-multiple-add-to-cart-products').each(function(i, index) {
					var checkbox = $(this);


					if(checkbox.is(':checked')) {

						var product_id = checkbox.data('product_id');
						var product_quantity = checkbox.parent().parent().find('input[name="quantity"]').val();

						var product = {
							id : product_id,
							quantity : parseInt(product_quantity),
						};
						data.products.push(product);
						checkbox.prop('checked', false);
					}
				});
				
				if(data.products.length < 1) {
					alert('No Products selected');
				}

				$.post( woocommerce_params.ajax_url, data, function( response ) {
					
					if ( ! response ) {
						return;
					}

					// if ( response.error && response.product_url ) {
					// 	window.location = response.product_url;
					// 	return;
					// }

					// // Redirect to cart option
					// if ( wc_add_to_cart_params.cart_redirect_after_add === 'yes' ) {
					// 	window.location = wc_add_to_cart_params.cart_url;
					// 	return;
					// }

					// Trigger event so themes can refresh other areas.
					

					$( document.body ).trigger( 'added_to_cart', [ response.fragments, response.cart_hash, $thisbutton ] );
				});

			});
		},
		quickOrderSearch : function() {

			var that = this;
			if(that.elements.quickOrderSearch.length < 1) {
				return false;
			}

			that.quickOrderSearchAction();
			that.quickOrderSearchAddProduct();
			that.quickOrderSearchAddRow();
			that.quickOrderSearchAddAllToCart();
			that.quickOrderSearchRemoveRow();
		},
		quickOrderSearchAction : function() {

			var that = this;
			var delayTimer;

			$(that.elements.quickOrderSearch).on('keyup', '.woocommerce-quick-order-search-input-field', function(e) {
                var $this = $(this);
                var term = $this.val();

                $('.woocommerce-quick-order-search-results').remove();

                if(term.length <= 3) {
	                var width = 100 / 3 * term.length;
	                $this.siblings('.woocommerce-quick-order-search-input-indication').css('width', width + '%');
                }

                if(term.length > 2) {
                    clearTimeout(delayTimer);
                    delayTimer = setTimeout(function() {
                        $.ajax({
                            type : 'post',
                            url : that.settings.ajax_url,
                            dataType : 'json',
                            data : {
                                term : term,
                                action : 'quick_order_search_products'
                            },
                            success : function( response ) {
                            	var html = '<div class="woocommerce-quick-order-search-results">';
                            	html += '<div class="woocommerce-quick-order-search-message">';
                            		html += response.message;
                        		html += '</div>';
                            	if(response.products.length > 0) {
                            		$.each(response.products, function(i, product) {
										html += '<a href="#" data-product-id="' + product.ID + '" data-product-img="' + product.img + '"data-product-name="' + product.name + '" data-product-price="' + product.price + '" class="woocommerce-quick-order-search-results-item">' +
											'<div class="woocommerce-quick-order-search-results-item-image">' +
												'<img src="' + product.img + '" alt="' + product.name + '" />' + 
											'</div>' +
											'<div class="woocommerce-quick-order-search-results-item-name">' +
												product.name +
												'<span class="woocommerce-quick-order-search-results-item-sku">(' + that.trans.sku + product.sku + ')</span>' +
											'</div>' +
											'<div class="clear clearfix"></div>' +
										'</a>';
                            		});
                        		}

                            	html += '</div>';

                            	$(html).insertAfter($this);
                            }
                         });
                    }, 700);
                }
			});
		},
		quickOrderSearchAddProduct : function() {

			var that = this;
			$(that.elements.quickOrderSearch).on('click', '.woocommerce-quick-order-search-results-item', function(e) {
				e.preventDefault();

				var $this = $(this);
				var tr = $this.parents('tr');

				var inputField = tr.find('.woocommerce-quick-order-search-input-field');
				var priceField = tr.find('.woocommerce-quick-order-search-price');
				var quantityField = tr.find('.woocommerce-quick-order-search-quantity-field');

				inputField.val($this.data('product-name'));
				inputField.data('product-id', $this.data('product-id'));
				
				inputField.addClass('woocommerce-quick-order-search-input-field-has-image').css('background-image', 'url(' + $this.data('product-img') + ')');
				priceField.html($this.data('product-price'));

				$this.parent('.woocommerce-quick-order-search-results').fadeOut().remove();
				$('.woocommerce-quick-order-search-add-row').trigger('click');
			});
		},
		quickOrderSearchAddRow : function() {

			var that = this;
			var emptyRow = 
			'<tr>' +
				'<td class="woocommerce-quick-order-search-input">' +
					'<div class="woocommerce-quick-order-search-input-indication"></div>' +
					'<input type="text" name="woocommerce-quick-order-search-input-field" class="woocommerce-quick-order-search-input-field" ' +
					'placeholder="' + that.trans.placeholder + '">' +
				'</td>' +
				'<td class="woocommerce-quick-order-search-price">' +
					'–' +
				'</td>' +
				'<td class="woocommerce-quick-order-search-quantity">' +
					'<input type="number" name="woocommerce-quick-order-quantity-field" class="woocommerce-quick-order-search-quantity-field" value="1">' +
				'</td>' +
				'<td class="woocommerce-quick-order-search-actions">' +
					'<a href="#" class="woocommerce-quick-order-search-remove-row">' +
						'<i class="fa fa-times"></i>' +
					'</a>' +
				'</td>' +
			'</tr>';

			$('.woocommerce-quick-order-search-add-row').on('click', function(e) {
				e.preventDefault();
				that.elements.quickOrderSearch.append(emptyRow);

			});

		},
		quickOrderSearchRemoveRow : function() {

			var that = this;

			$(that.elements.quickOrderSearch).on('click', '.woocommerce-quick-order-search-remove-row', function(e) {
				e.preventDefault();
				$(this).parents('tr').fadeOut().remove();
			});
		},
		quickOrderSearchAddAllToCart : function() {

			var that = this;

			$('.woocommerce-quick-order-search-add-to-cart-btn').on('click', function(e) {
				e.preventDefault();
				var $thisbutton = $(this);

				var data = {
					'action' : 'woocommerce_quick_order_add_to_cart',
					'products' : [],
				};

				var rows = that.elements.quickOrderSearch.find('tr');
				var tr;
				$.each(rows, function(i, index) {

					tr = $(this);

					var product_id = tr.find('.woocommerce-quick-order-search-input-field').data('product-id');
					var quantity = tr.find('.woocommerce-quick-order-search-quantity-field').val();

					if(product_id == "" || typeof product_id == "undefined" || quantity == "" || typeof quantity == "undefined") {
						return true;
					}

					var product = {
						id : product_id,
						quantity : parseInt(quantity),
					};

					data.products.push(product);

					tr.fadeOut();
				});

				$.post( woocommerce_params.ajax_url, data, function( response ) {
					
					if ( ! response ) {
						return;
					}

					// if ( response.error && response.product_url ) {
					// 	window.location = response.product_url;
					// 	return;
					// }

					// // Redirect to cart option
					// if ( wc_add_to_cart_params.cart_redirect_after_add === 'yes' ) {
					// 	window.location = wc_add_to_cart_params.cart_url;
					// 	return;
					// }

					// Trigger event so themes can refresh other areas.
					

					$( document.body ).trigger( 'added_to_cart', [ response.fragments, response.cart_hash, $thisbutton ] );
				});
			});
		}
	} );

	// Constructor wrapper
	$.fn[ pluginName ] = function( options ) {
		return this.each( function() {
			if ( !$.data( this, "plugin_" + pluginName ) ) {
				$.data( this, "plugin_" +
					pluginName, new Plugin( this, options ) );
			}
		} );
	};

	$(document).ready(function() {

		$( "body" ).quickOrder( 
			woocommerce_quick_order_options
		);

	} );

})( jQuery );