<?php

    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "woocommerce_quick_order_options";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name' => 'woocommerce_quick_order_options',
        'use_cdn' => TRUE,
        'dev_mode' => FALSE,
        'display_name' => 'WooCommerce Quick Order',
        'display_version' => '1.0.3',
        'page_title' => 'WooCommerce Quick Order',
        'update_notice' => TRUE,
        'intro_text' => '',
        'footer_text' => '&copy; '.date('Y').' DB-Dzine',
        'admin_bar' => TRUE,
        'menu_type' => 'submenu',
        'menu_title' => 'Quick Order',
        'allow_sub_menu' => TRUE,
        'page_parent' => 'woocommerce',
        'page_parent_post_type' => 'your_post_type',
        'customizer' => FALSE,
        'default_mark' => '*',
        'hints' => array(
            'icon_position' => 'right',
            'icon_color' => 'lightgray',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'light',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
                    'duration' => '500',
                    'event' => 'mouseover',
                ),
                'hide' => array(
                    'duration' => '500',
                    'event' => 'mouseleave unfocus',
                ),
            ),
        ),
        'output' => TRUE,
        'output_tag' => TRUE,
        'settings_api' => TRUE,
        'cdn_check_time' => '1440',
        'compiler' => TRUE,
        'page_permissions' => 'manage_options',
        'save_defaults' => TRUE,
        'show_import_export' => TRUE,
        'database' => 'options',
        'transient_time' => '3600',
        'network_sites' => TRUE,
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'help-tab',
            'title'   => __( 'Information', 'woocommerce-quick-order' ),
            'content' => __( '<p>Need support? Please use the comment function on codecanyon.</p>', 'woocommerce-quick-order' )
        ),
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    // $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'woocommerce-quick-order' );
    // Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    Redux::setSection( $opt_name, array(
        'title'  => __( 'Quick Order', 'woocommerce-quick-order' ),
        'id'     => 'general',
        'desc'   => __( 'Need support? Please use the comment function on codecanyon.', 'woocommerce-quick-order' ),
        'icon'   => 'el el-home',
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'General', 'woocommerce-quick-order' ),
        // 'desc'       => __( '', 'woocommerce-quick-order' ),
        'id'         => 'general-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'enable',
                'type'     => 'checkbox',
                'title'    => __( 'Enable', 'woocommerce-quick-order' ),
                'default'  => 1,
            ),
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Data to Show', 'woocommerce-quick-order' ),
        'desc'       => __( 'Configure the table.', 'woocommerce-quick-order' ),
        'id'         => 'variations',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'      => 'dataToShowData',
                'type'    => 'sorter',
                'title'   => 'Variation Data',
                'subtitle'    => 'Reorder, enable or disable data fields.',
                'options' => array(
                    'enabled' => array(
                        'mc' => __('Multiple Cart', 'woocommerce-quick-order'),
                        'im' => __('Image', 'woocommerce-quick-order'),
                        'pt' => __('Name', 'woocommerce-quick-order'),
                        'sk' => __('SKU', 'woocommerce-quick-order'),
                        'pr' => __('Price', 'woocommerce-quick-order'),
                        'st' => __('Stock', 'woocommerce-quick-order'),
                        // 'at' => __('Attributes', 'woocommerce-quick-order'),
                        'ca' => __('Add to Cart', 'woocommerce-quick-order'),
                    ),
                    'disabled' => array(
                        'qt' => __('Quantity', 'woocommerce-quick-order'),
                        'rm' => __('Read More', 'woocommerce-quick-order'),
                        'ct' => __('Category', 'woocommerce-quick-order'),
                        'de' => __('Short Description', 'woocommerce-quick-order'),
                        'di' => __('Dimensions', 'woocommerce-quick-order'),
                        'we' => __('Weight', 'woocommerce-quick-order'),
                    )
                ),
            ),
            array(
                'id'       => 'dataToShowShowQuantity',
                'type'     => 'checkbox',
                'title'    => __( 'Show Quantity Field', 'woocommerce-quick-order' ),
                'subtitle' => __( 'Show the Quantity field for Add to Cart', 'woocommerce-quick-order' ),
                'default'  => 0
            ),
            array(
                'id'       => 'datatablesEnable',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Datatables', 'woocommerce-quick-order' ),
                'default'  => 1,
            ),
            array(
                'id'       => 'datatablesLanguage',
                'type'     => 'select',
                'title'    => __('Datatables Language', 'woocommerce-quick-order'),
                'subtitle' => __('Set a language for the datatable.', 'woocommerce-quick-order'),
                'default'  => 'English',
                'options'  => array( 
                    'Afrikaans' => __('Afrikaans', 'woocommerce-quick-order'),
                    'Albanian' => __('Albanian', 'woocommerce-quick-order'),
                    'Amharic' => __('Amharic', 'woocommerce-quick-order'),
                    'Arabic' => __('Arabic', 'woocommerce-quick-order'),
                    'Armenian' => __('Armenian', 'woocommerce-quick-order'),
                    'Azerbaijan' => __('Azerbaijan', 'woocommerce-quick-order'),
                    'Bangla' => __('Bangla', 'woocommerce-quick-order'),
                    'Basque' => __('Basque', 'woocommerce-quick-order'),
                    'Belarusian' => __('Belarusian', 'woocommerce-quick-order'),
                    'Bulgarian' => __('Bulgarian', 'woocommerce-quick-order'),
                    'Catalan' => __('Catalan', 'woocommerce-quick-order'),
                    'Chinese-traditional' => __('traditional', 'woocommerce-quick-order'),
                    'Chinese' => __('Chinese', 'woocommerce-quick-order'),
                    'Croatian' => __('Croatian', 'woocommerce-quick-order'),
                    'Czech' => __('Czech', 'woocommerce-quick-order'),
                    'Danish' => __('Danish', 'woocommerce-quick-order'),
                    'Dutch' => __('Dutch', 'woocommerce-quick-order'),
                    'English' => __('English', 'woocommerce-quick-order'),
                    'Estonian' => __('Estonian', 'woocommerce-quick-order'),
                    'Filipino' => __('Filipino', 'woocommerce-quick-order'),
                    'Finnish' => __('Finnish', 'woocommerce-quick-order'),
                    'French' => __('French', 'woocommerce-quick-order'),
                    'Galician' => __('Galician', 'woocommerce-quick-order'),
                    'Georgian' => __('Georgian', 'woocommerce-quick-order'),
                    'German' => __('German', 'woocommerce-quick-order'),
                    'Greek' => __('Greek', 'woocommerce-quick-order'),
                    'Gujarati' => __('Gujarati', 'woocommerce-quick-order'),
                    'Hebrew' => __('Hebrew', 'woocommerce-quick-order'),
                    'Hindi' => __('Hindi', 'woocommerce-quick-order'),
                    'Hungarian' => __('Hungarian', 'woocommerce-quick-order'),
                    'Icelandic' => __('Icelandic', 'woocommerce-quick-order'),
                    'Indonesian-Alternative' => __('Alternative', 'woocommerce-quick-order'),
                    'Indonesian' => __('Indonesian', 'woocommerce-quick-order'),
                    'Irish' => __('Irish', 'woocommerce-quick-order'),
                    'Italian' => __('Italian', 'woocommerce-quick-order'),
                    'Japanese' => __('Japanese', 'woocommerce-quick-order'),
                    'Kazakh' => __('Kazakh', 'woocommerce-quick-order'),
                    'Korean' => __('Korean', 'woocommerce-quick-order'),
                    'Kyrgyz' => __('Kyrgyz', 'woocommerce-quick-order'),
                    'Latvian' => __('Latvian', 'woocommerce-quick-order'),
                    'Lithuanian' => __('Lithuanian', 'woocommerce-quick-order'),
                    'Macedonian' => __('Macedonian', 'woocommerce-quick-order'),
                    'Malay' => __('Malay', 'woocommerce-quick-order'),
                    'Mongolian' => __('Mongolian', 'woocommerce-quick-order'),
                    'Nepali' => __('Nepali', 'woocommerce-quick-order'),
                    'Norwegian-Bokmal' => __('Bokmal', 'woocommerce-quick-order'),
                    'Norwegian-Nynorsk' => __('Nynorsk', 'woocommerce-quick-order'),
                    'Pashto' => __('Pashto', 'woocommerce-quick-order'),
                    'Persian' => __('Persian', 'woocommerce-quick-order'),
                    'Polish' => __('Polish', 'woocommerce-quick-order'),
                    'Portuguese-Brasil' => __('Brasil', 'woocommerce-quick-order'),
                    'Portuguese' => __('Portuguese', 'woocommerce-quick-order'),
                    'Romanian' => __('Romanian', 'woocommerce-quick-order'),
                    'Russian' => __('Russian', 'woocommerce-quick-order'),
                    'Serbian' => __('Serbian', 'woocommerce-quick-order'),
                    'Sinhala' => __('Sinhala', 'woocommerce-quick-order'),
                    'Slovak' => __('Slovak', 'woocommerce-quick-order'),
                    'Slovenian' => __('Slovenian', 'woocommerce-quick-order'),
                    'Spanish' => __('Spanish', 'woocommerce-quick-order'),
                    'Swahili' => __('Swahili', 'woocommerce-quick-order'),
                    'Swedish' => __('Swedish', 'woocommerce-quick-order'),
                    'Tamil' => __('Tamil', 'woocommerce-quick-order'),
                    'telugu' => __('telugu', 'woocommerce-quick-order'),
                    'Thai' => __('Thai', 'woocommerce-quick-order'),
                    'Turkish' => __('Turkish', 'woocommerce-quick-order'),
                    'Ukrainian' => __('Ukrainian', 'woocommerce-quick-order'),
                    'Urdu' => __('Urdu', 'woocommerce-quick-order'),
                    'Uzbek' => __('Uzbek', 'woocommerce-quick-order'),
                    'Vietnamese' => __('Vietnamese', 'woocommerce-quick-order'),
                    'Welsh' => __('Welsh', 'woocommerce-quick-order'),
                ),
            ),
            array(
                'id'       => 'datatablesPaging',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Paging', 'woocommerce-quick-order' ),
                'default'  => 0,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesOrdering',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Ordering', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesInfo',
                'type'     => 'checkbox',
                'title'    => __( 'Show Info', 'woocommerce-quick-order' ),
                'default'  => 0,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesFiltering',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Filtering', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesStateSave',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Filter & Search Saving', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesSearching',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Searching', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesScrollCollapse',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Scrolling', 'woocommerce-quick-order' ),
                'default'  => 0,
                 'required' => array('datatablesEnable','equals','1'),
            ),
           array(
                'id'       => 'datatablesScrollY',
                'type'     => 'spinner',
                'title'    => __( 'Scroll Max Height', 'woocommerce-quick-order' ),
                'min'      => '1',
                'step'     => '1',
                'max'      => '99999',
                'default'  => '250',
                'required' => array('datatablesScrollCollapse','equals','1'),
            ),
            array(
                'id'       => 'datatablesResponsive',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Responsive', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesSDom',
                'type'     => 'text',
                'title'    => __( 'sDOM (leave as it is) Defalult is: W<"clear">Blfrtip', 'woocommerce-quick-order' ),
                'default'  => 'W<"clear">Blfrtip',
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesPrint',
                'type'     => 'checkbox',
                'title'    => __( 'Show Print Export-Button', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesCopyHtml5',
                'type'     => 'checkbox',
                'title'    => __( 'Show Copy Export-Button', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesExcelHtml5',
                'type'     => 'checkbox',
                'title'    => __( 'Show Excel Export-Button', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesCsvHtml5',
                'type'     => 'checkbox',
                'title'    => __( 'Show CSV Export-Button', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
            array(
                'id'       => 'datatablesPdfHtml5',
                'type'     => 'checkbox',
                'title'    => __( 'Show PDF Export-Button', 'woocommerce-quick-order' ),
                'default'  => 1,
                'required' => array('datatablesEnable','equals','1'),
            ),
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Limitations', 'woocommerce-quick-order' ),
        'desc'       => __( 'Apply Quick Order for specific users / roles.', 'woocommerce-quick-order' ),
        'id'         => 'limitations',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'applyForUserGroup',
                'type'     => 'select',
                'title'    => __('Apply for users', 'woocommerce-quick-order'), 
                'subtitle' => __('Which user group should be allowed to see the quick order shortcodes.', 'woocommerce-quick-order'),
                'options'  => array(
                    '1' => __('All', 'woocommerce-quick-order' ),
                    '2' => __('Only NOT logged in', 'woocommerce-quick-order' ),
                    '3' => __('Only Logged in', 'woocommerce-quick-order' ),
                ),
                'default'  => '1',
            ),
            array(
                'id'     => 'applyForExcludeUserRoles',
                'type'   => 'select',
                'data'   => 'roles',
                'title'  => __('Exclude User Roles', 'woocommerce-quick-order'),
                'subtitle' => __('Select user roles, where the plugin should NOT apply.', 'woocommerce-quick-order'),
                'multi'    => true,
                'default'  => '',
            ),
        )
    ));

    /*
     * <--- END SECTIONS
     */
