<?php
// Prevent direct file access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Gets data for a custom taxonomy column.
 *
 * @package   WooCommerce_Product_Table\Data
 * @author    Barn2 Media <info@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Product_Table_Data_Custom_Taxonomy extends Abstract_Product_Table_Data {

	private $taxonomy;
	private $date_format;
	private $is_date;

	public function __construct( $product, $taxonomy, $links = '', $date_format = '', $is_date = false ) {
		parent::__construct( $product, $links );

		$this->taxonomy		 = $taxonomy;
		$this->date_format	 = $date_format;
		$this->is_date		 = $is_date;
	}

	public function get_data() {
		$result = $this->get_product_taxonomy_terms( 'tax:' . $this->taxonomy );

		/* @deprecated 2.2 - replaced by wc_product_table_data_taxonomy. */
		$result = apply_filters( 'wc_product_table_data_terms', $result, $this->product );

		// Filter the result.
		$result	 = apply_filters( 'wc_product_table_data_taxonomy', $result, $this->taxonomy, $this->product );
		$result	 = apply_filters( 'wc_product_table_data_taxonomy_' . $this->taxonomy, $result, $this->product );

		return $result;
	}

	public function get_sort_data() {
		if ( $this->is_date ) {
			$date		 = false;
			$date_terms	 = wc_get_product_terms( $this->get_parent_product_id(), $this->taxonomy, array( 'fields' => 'names' ) );

			if ( is_array( $date_terms ) && 1 === count( $date_terms ) ) {
				$date = reset( $date_terms );
			}

			// Format the hidden date column for sorting
			if ( $date && $timestamp = WCPT_Util::strtotime( $date, $this->date_format ) ) {
				return $timestamp;
			}
		}
		return '';
	}

}