<?php
$wpt_style_file_selection_options = WOO_Product_Table::$style_form_options;
?>

<?php
    /**
     * To Get Category List of WooCommerce
     * @since 1.0.0 -10
     */
    $args = array(
        'hide_empty' => false, //False from 3.4 
        'orderby' => 'count',
        'order' => 'DESC',
    );

    //WooCommerce Product Category Object as Array
    $wpt_product_cat_object = get_terms('product_cat', $args);
    //var_dump($wpt_product_cat_object);
?>


<div class="wpt_column">
    <label class="wpt_label" for="wpt_product_slugs">Category Includes <small>(Click to choose Categories)</small></label>
    <select data-name="product_cat_ids" id="wpt_product_ids" class="wpt_fullwidth wpt_data_filed_atts" multiple>
        <?php
        foreach ($wpt_product_cat_object as $category) {
            echo "<option value='{$category->term_id}' " . ( is_array($wpt_product_ids) && in_array($category->term_id, $wpt_product_ids) ? 'selected' : false ) . ">{$category->name} - {$category->slug} ({$category->count})</option>";
        }
        ?>
    </select>
</div>


<div class="wpt_column">
    <label class="wpt_label">Product ID Exclude (Separate with comma)</label>
    <input data-name="post_exclude" class="wpt_data_filed_atts" type="text" placeholder="Example: 1,2,3,4">
</div>
<div class="wpt_column">
    <label class="wpt_label" for="wpt_product_slugs">Category Exclude <small>(Click to choose Categories)</small></label>
    <select data-name="cat_explude" id="wpt_product_ids" class="wpt_fullwidth wpt_data_filed_atts" multiple>
        <?php
        foreach ($wpt_product_cat_object as $category) {
            echo "<option value='{$category->term_id}' " . ( is_array($wpt_product_ids) && in_array($category->term_id, $wpt_product_ids) ? 'selected' : false ) . ">{$category->name} - {$category->slug} ({$category->count})</option>";
        }
        ?>
    </select>
</div>


<?php
    $wpt_product_ids_tag = false;
    /**
     * To Get Category List of WooCommerce
     * @since 1.0.0 -10
     */
    $args = array(
        'hide_empty' => true,
        'orderby' => 'count',
        'order' => 'DESC',
    );

    //WooCommerce Product Category Object as Array
    $wpt_product_tag_object = get_terms('product_tag', $args);
    //var_dump($wpt_product_tag_object);
?>


<div class="wpt_column">
    <label class="wpt_label" for="product_tag_ids">Tag Includes <small>(Click to choose Tags)</small></label>
    <select data-name="product_tag_ids" id="product_tag_ids" class="wpt_fullwidth wpt_data_filed_atts" multiple>
        <?php
        foreach ($wpt_product_tag_object as $tags) {
            echo "<option value='{$tags->term_id}' " . ( is_array($wpt_product_ids_tag) && in_array($tags->term_id, $wpt_product_ids_tag) ? 'selected' : false ) . ">{$tags->name} - {$tags->slug} ({$tags->count})</option>";
        }
        ?>
    </select>
</div>

<div class="wpt_column">
    <label class="wpt_table_ajax_action" for='wpt_table_minicart_position'>Ajax Action (Enable/Disable)</label>
    <select data-name='ajax_action' id="wpt_table_ajax_action" class="wpt_fullwidth wpt_data_filed_atts" >
        <option value="" selected="selected">Active Ajax (Default)</option>
        <option value="no">Disable Ajax Action</option>
    </select>
</div>


<div class="wpt_column">
    <label class="wpt_label" for='wpt_table_minicart_position'>Mini Cart Position</label>
    <select data-name='minicart_position' id="wpt_table_minicart_position" class="wpt_fullwidth wpt_data_filed_atts" >
        <option value="" selected="selected">Top (Default)</option>
        <option value="bottom">Bottom</option>
        <option value="none">None</option>
    </select>
</div>



<div class="wpt_column">
    <label class="wpt_label" for="wpt_style_file_selection">Select Template</label>
    <select data-name="template" id="wpt_style_file_selection"  class="wpt_fullwidth wpt_data_filed_atts" >
        <?php
        foreach ($wpt_style_file_selection_options as $key => $value) {
            echo "<option value='$key'>$value</option>";
        }
        ?>
    </select>
</div>


<div class="wpt_column">
    <label class="wpt_label" for='wpt_table_table_class'>Set a Class name for Table</label>
    <input class="wpt_data_filed_atts" data-name="table_class" type="text" placeholder="Product's Table Class Name (Optional)" id='wpt_table_table_class'>
</div>
<div class="wpt_column">
    <label class="wpt_label" for='wpt_table_temp_number'>Temporary Number for Table</label>
    <input class="wpt_data_filed_atts" data-name="temp_number" type="text" placeholder="123" id='wpt_table_temp_number' value="<?php echo random_int(10, 300); ?>">
    <p>This is not very important, But should different number for different shortcode of your table. Mainly to identify each table.</p>
</div>


<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_add_to_cart_text">(Add to cart) Text</label>
    <input class="wpt_data_filed_atts" data-name="add_to_cart_text" type="text" placeholder="Example: Buy" id="wpt_table_add_to_cart_text">
    <p style="color: #006799;padding: 0;margin: 0;">Put a Space (" ") for getting default <b>Add to Cart Text</b></p>
</div>
<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_added_to_cart_text">Added_to_cart (Added) Text</label>
    <input class="wpt_data_filed_atts" data-name="added_to_cart_text" type="text" placeholder="Example: Added" id="wpt_table_added_to_cart_text">
</div>
<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_adding_to_cart_text">Added_to_cart (Adding..) Text</label>
    <input class="wpt_data_filed_atts" data-name="adding_to_cart_text" type="text" placeholder="Example: Adding.." id="wpt_table_added_to_cart_text">
</div>

<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_add_to_cart_selected_text">(Add to cart[Selected]) Text</label>
    <input class="wpt_data_filed_atts" data-name="add_to_cart_selected_text" type="text" placeholder="Example: Add to cart Selected" id="wpt_table_add_to_cart_selected_text">
</div>

<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_check_uncheck_text">(All Check/Uncheck) Text</label>
    <input class="wpt_data_filed_atts" data-name="check_uncheck_text" type="text" placeholder="Example: All Check/Uncheck" id="wpt_table_check_uncheck_text">
</div>
<hr> 
<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_author">AuthorID/UserID/VendorID<strong>(Optional)</strong></label>
    <input class="wpt_data_filed_atts" data-name="author" type="number" placeholder="Author ID/Vendor ID" id="wpt_table_author">
    <p style="color: #006394;">Only AuthorID or AuthorName field for both [AuthorID/UserID/VendorID] or [author_name/username/VendorUserName]. Don't use both.</p>
</div>
<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_author_name">author_name/username/VendorUserName<strong>(Optional)</strong></label>
    <input class="wpt_data_filed_atts" data-name="author_name" type="text" placeholder="Author username/ Vendor username" id="wpt_table_author_name">
    <p style="color: #006394;">Only AuthorID or AuthorName field for both [AuthorID/UserID/VendorID] or [author_name/username/VendorUserName]. Don't use both.</p>
</div>

