<?php
	#################################################################
	##  WHMX Billing system for cPanel / WHM					   ##
	##-------------------------------------------------------------##
	##  Version: 1.00 - ENVATO MARKET                              ##
	##-------------------------------------------------------------##
	##  Author: Gianck Luiz obviosistemas@gmail.com         	   ##
	##-------------------------------------------------------------##
	##  Copyright ©2016 . All rights reserved.	                   ##
	##-------------------------------------------------------------##
	#################################################################
	
require_once("conexao.php"); 

function anti_injection($sql){
   $sql = preg_replace(sql_regcase("/(from|select|insert|delete|where|drop table|show tables|#|\*|--|\\\\)/"), "" ,$sql);
   $sql = trim($sql);
   $sql = strip_tags($sql);
   $sql = (get_magic_quotes_gpc()) ? $sql : addslashes($sql);
   return $sql;
}

$host = $host; // servidor
$database = $banco; // nome do banco
$login_db = $usuario; // usuario do banco 
$senha_db = $senha; // senha do usuario do banco

define('HOST', $host);	
define('BANCO',  $database);
define('LOGIN',  $login_db);
define('SENHA',  $senha_db);		

$cn=mysql_connect($host, $login_db, $senha_db);
mysql_select_db($database);

if (defined('ENVIRONMENT'))
{
	switch (ENVIRONMENT)
	{
		case 'development':
			error_reporting(E_ALL);
		break;
	
		case 'testing':
		case 'production':
			error_reporting(0);
		break;

		default:
			exit('The application environment is not set correctly.');
	}
}

class conexao
{

    /*
    CONEXÃO CRUDS
    */

    private $db_host = HOST; // servidor
    private $db_user = LOGIN; // usuario do banco
    private $db_pass = SENHA; // senha do usuario do banco
    private $db_name = BANCO; // nome do banco

    private $con = false;

   
    public function connect() // Estabelece conexao
    {
        if(!$this->con)
        {
            $myconn = @mysql_connect($this->db_host,$this->db_user,$this->db_pass);
            if($myconn)
            {
                $seldb = @mysql_select_db($this->db_name,$myconn);
                if($seldb)
                {
                    $this->con = true;
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
        }
        else
        {
            return true;
        }
    }

   
    public function disconnect() // Fecha conexao
    {
    if($this->con)
    {
        if(@mysql_close())
        {
                        $this->con = false;
            return true;
        }
        else
        {
            return false;
        }
    }
    }
      
}

 
function geraSenha($tamanho = 8, $maiusculas = true, $numeros = true, $simbolos = false)
  {
  $lmin = 'abcdefghijklmnopqrstuvwxyz';
  $lmai = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  $num = '1234567890';
  $simb = '!@#$%*-';
  $retorno = '';
  $caracteres = '';

  $caracteres .= $lmin;
  if ($maiusculas) $caracteres .= $lmai;
  if ($numeros) $caracteres .= $num;
  if ($simbolos) $caracteres .= $simb;

  $len = strlen($caracteres);
  for ($n = 1; $n <= $tamanho; $n++) {
  $rand = mt_rand(1, $len);
  $retorno .= $caracteres[$rand-1];
  }
  return $retorno;
  }
  
  function celular($string)
  {
  $string = str_replace('(','',$string);
  $string = str_replace(')','',$string);
  $string = str_replace('-','',$string);
  $string = str_replace(' ','',$string);
  $string = str_replace('.','',$string);
  return $string;
  }
  
  function data_br($datasql)
  {
  $date = new DateTime($datasql);
  $retorno = $date->format('d/m/Y'); 
  return $retorno;
  }
  function data_en($datasql)
  {
  $date = new DateTime($datasql);
  $retorno = $date->format('m-d-Y'); 
  return $retorno;
  }
  
  function diff_date($inicio, $fim) {

        $di = explode("-",$inicio);
        $df = explode("-", $fim);

        $dinicio = mktime(date('H'), date('i'), date('s'), $di[1], $di[2], $di[0]);
        $dfim = mktime(date('H'), date('i'), date('s'), $df[1], $df[2], $df[0]);
        $dias = abs((($dinicio - $dfim) / (60*60*24)));

        return number_format($dias,0,'','');

    }
    
    function urlon($site) {
		$cURL = curl_init();
		curl_setopt($cURL, CURLOPT_URL, $site);
		curl_setopt($cURL, CURLOPT_RETURNTRANSFER, false);
		curl_setopt($cURL, CURLOPT_HEADER, false);
		curl_setopt($cURL, CURLOPT_NOBODY, true);
		if(curl_exec($cURL)){
			echo "<span class='label label-success'>ONLINE</span>";
			$resultado = curl_exec($cURL);
		}
		else
			echo "<span class='label label-danger'>OFFLINE</span>";
		curl_close($cURL);
    }
    
    function limitText($texto, $limite){
  $contador = strlen($texto);
  if ( $contador >= $limite ) {      
      $texto = substr($texto, 0, strrpos(substr($texto, 0, $limite), ' ')) . '...';
      return $texto;
  }
  else{
    return $texto;
  }
} 

function gravatar($gravatar){
$gravatar_link = 'http://www.gravatar.com/avatar/' . md5($gravatar) . '?s=128';
return $gravatar_link;
}
    
function srvon($srvon) {
	 
$fp = @fsockopen($srvon, 2083, $errno, $errstr, 1);
if($fp >= 1){ 
$regg = "<span class='label label-success'>ONLINE</span>";
}else{
$regg = "<span class='label label-danger'>OFFLINE</span>";
} 
	return $regg; 
	 
}

function rand_char($length) {
  $random = '';
  for ($i = 0; $i < $length; $i++) {
    $random .= md5(mt_rand(33, 126));
  }
  return $random;
}

function rrmb($string)
{
  $string = str_replace('M','',$string);
  $string = str_replace('G','',$string);
  $string = str_replace('K','',$string);
  $string = str_replace('B','',$string);

  return $string;
  
  } 
  
 function acento($string)
{
  $string = str_replace('á','a',$string);
  $string = str_replace('Á','A',$string);
  $string = str_replace('à','a',$string);
  $string = str_replace('À','A',$string);
  $string = str_replace('â','a',$string);
  $string = str_replace('Â','A',$string);
  $string = str_replace('ã','a',$string);
  $string = str_replace('Ã','A',$string);
  $string = str_replace('ç','c',$string);
  $string = str_replace('Ç','C',$string);
  $string = str_replace('é','e',$string);
  $string = str_replace('É','E',$string);
  $string = str_replace('ê','e',$string);
  $string = str_replace('Ê','E',$string);
  $string = str_replace('è','e',$string);
  $string = str_replace('È','E',$string);
  $string = str_replace('í','i',$string);
  $string = str_replace('Í','I',$string);
  $string = str_replace('ó','o',$string);
  $string = str_replace('Ó','O',$string);
  $string = str_replace('ô','o',$string);
  $string = str_replace('Ô','O',$string);
  $string = str_replace('õ','o',$string);
  $string = str_replace('Õ','O',$string);
  $string = str_replace('ú','u',$string);
  $string = str_replace('Ú','U',$string);
  $string = str_replace('~','',$string);
  $string = str_replace('&','e',$string);
  $string = str_replace('.','_',$string);
  $string = str_replace('-','_',$string);
  $string = str_replace(',','_',$string);
  $string = str_replace(';','_',$string);
  $string = str_replace(':','_',$string);
  $string = str_replace(' ',' ',$string);
  return $string;
  
  } 

function fLogAcesso($msg){
	$user = $_SESSION['id'];
	$link = $_SERVER["PHP_SELF"];
	$ip = $_SERVER['REMOTE_ADDR'];
	$data = date("Y-m-d");
	$hora = date("H:i:s");
	$rtm = $msg;
	
	$useragent = $_SERVER['HTTP_USER_AGENT'];
 
	  if (preg_match('|MSIE ([0-9].[0-9]{1,2})|',$useragent,$matched)) {
		$browser_version=$matched[1];
		$browser = 'IE';
	  } elseif (preg_match( '|Opera/([0-9].[0-9]{1,2})|',$useragent,$matched)) {
		$browser_version=$matched[1];
		$browser = 'Opera';
	  } elseif(preg_match('|Firefox/([0-9\.]+)|',$useragent,$matched)) {
		$browser_version=$matched[1];
		$browser = 'Firefox';
	  } elseif(preg_match('|Chrome/([0-9\.]+)|',$useragent,$matched)) {
		$browser_version=$matched[1];
		$browser = 'Chrome';
	  } elseif(preg_match('|Safari/([0-9\.]+)|',$useragent,$matched)) {
		$browser_version=$matched[1];
		$browser = 'Safari';
	  } else {
		// browser not recognized!
		$browser_version = 0;
		$browser= 'other';
	  }
	  $navegador = $browser." - ".$browser_version;
	
	$crud = new crud('log_tb');  // table
    $crud->inserir("navegador, user, link, ip, data, hora, msg", "'$navegador', '$user', '$link', '$ip', '$data', '$hora', '$rtm'");

	return true;
}


function humanTiming ($time)
{

    $time = time() - $time; // to get the time since that moment
    $time = ($time<1)? 1 : $time;
    $tokens = array (
        31536000 => 'year',
        2592000 => 'month',
        604800 => 'week',
        86400 => 'day',
        3600 => 'hour',
        60 => 'minute',
        1 => 'second'
    );

    foreach ($tokens as $unit => $text) {
        if ($time < $unit) continue;
        $numberOfUnits = floor($time / $unit);
        return $numberOfUnits.' '.$text.(($numberOfUnits>1)?'s':'');
    }

}


function getOs(){
	 
	 $useragent = $_SERVER['HTTP_USER_AGENT'];
	 
	 $useragent = strtolower($useragent);
	 
	 //check for (aaargh) most popular first
	 //winxp
	 if(strpos("$useragent","windows nt 5.1") !== false)
	 {
	 return "Windows XP";
	 }
	 elseif (strpos("$useragent","windows nt 6.0") !== false)
	 {
	 return "Windows Vista";
	 }
	 elseif (strpos("$useragent","windows nt 6.1") !== false)
	 {
	 return "Windows 7";
	 }
	 elseif (strpos("$useragent","windows 98") !== false)
	 {
	 return "Windows 98";
	 }
	 elseif (strpos("$useragent","windows nt 5.0") !== false)
	 {
	 return "Windows 2000";
	 }
	 elseif (strpos("$useragent","windows nt 5.2") !== false)
	 {
	 return "Windows 2003 server";
	 }
	 elseif (strpos("$useragent","windows nt 6.0") !== false)
	 {
	 return "Windows Vista";
	 }
	 elseif (strpos("$useragent","windows nt") !== false)
	 {
	 return "Windows NT";
	 }
	 elseif (strpos("$useragent","win 9x 4.90") !== false && strpos("$useragent","win me"))
	 {
	 return "Windows ME";
	 }
	 elseif (strpos("$useragent","win ce") !== false)
	 {
	 return "Windows CE";
	 }
	 elseif (strpos("$useragent","win 9x 4.90") !== false)
	 {
	 return "Windows ME";
	 }
	 elseif (strpos("$useragent","iphone") !== false)
	 {
	 return "iPhone";
	 }
	 elseif (strpos("$useragent","mac os x") !== false)
	 {
	 return "Mac OS X";
	 }
	 elseif (strpos("$useragent","macintosh") !== false)
	 {
	 return "Macintosh";
	 }
	 elseif (strpos("$useragent","linux") !== false)
	 {
	 return "Linux";
	 }
	 elseif (strpos("$useragent","freebsd") !== false)
	 {
	 return "Free BSD";
	 }
	 elseif (strpos("$useragent","symbian") !== false)
	 {
	 return "Symbian";
	 }
	 else
	 {
	 return false;
	 }
	 }

?>
