<?php

namespace WeDevs\PM_Pro\Search\Controllers;

use WP_REST_Request;
use League\Fractal\Resource\Item as Item;
use League\Fractal\Resource\Collection as Collection;
use WeDevs\PM\Common\Traits\Transformer_Manager;
use WeDevs\PM\Common\Traits\Request_Filter;
use WeDevs\PM_Pro\User\Models\User;
use WeDevs\PM\Project\Models\Project;
use WeDevs\PM\Task\Models\Task;
use WeDevs\PM\Common\Models\Board;
use Illuminate\Database\Capsule\Manager as DB;

class Search_Controller {
	use Transformer_Manager, Request_Filter;

	public function search_by_client( WP_REST_Request $request ) {
        $string = $request->get_param('query');
		$current_user_id = get_current_user_id();
		$projects = [];
		
        $users = User::with( 'projects' )
                ->where( 'display_name', 'like', '%'.$string.'%' )
                ->orWhere( 'user_login',  'like', '%'.$string.'%' )
                ->orWhere( 'user_nicename',  'like', '%'.$string.'%' )
                ->orWhere( 'user_email', 'like', '%'.$string.'%' )
                ->get();


        $users->map( function( $user ) use ( &$projects, $current_user_id ) {
            $user->projects->map( function( $project ) use ( &$projects, $current_user_id ) {
				if ( pm_is_user_in_project( $project->id, $current_user_id ) ) {
					$projects[] = $project->toArray();
				}
			});

        });

        if ( empty( $projects ) ) {
            $projects = [ [ "no_result" => __( "No result found.", 'pm-pro' )] ];
        }
        
        return $projects;
    }

    public function search_all( WP_REST_Request $request ) {
    	$string = $request->get_param( 'query' );
    	$project_id = $request->get_param( 'project_id' );
    	
    	if ( $project_id ) {
    		return $this->get_result_by_project( $string, $project_id );
    	}
    	return $this->get_result( $string );
    }

    public function get_result( $string ) {
		$items    = [];
		$projects = Project::where( 'title', 'like', '%'. $string.'%')->get();
		$items    = array_merge( $items, $this->get_items( $projects, 'project' ) );
		
		$tasks = Task::with( [ 
    			'metas' =>  function( $q ) {
    				$q->where('meta_key', 'privacy')->where('meta_value', 1);
    			}
    		])
            ->where( 'title', 'like', '%'. $string.'%')
            ->get();

		$items = array_merge( $items, $this->get_items( $tasks, 'task' ));

		$board = Board::with([
    			'metas'	=> function( $q ) {
    				$q->where('meta_key', 'privacy')->where('meta_value', 1);
    			}
    		])
            ->where( 'title', 'like', '%'. $string.'%')
            ->get();

		$items = array_merge( $items, $this->get_items( $board, 'board' ));
        if ( empty( $items ) ) {
            $items = [ [ "no_result" => __( "No result found.", 'pm-pro' ) ]];
        }
    	return $items;
    }

    public function get_result_by_project( $string, $project_id ) {
		$items = [];
		
		$tasks = Task::with( [ 
    			'metas' =>  function( $q ) {
    				$q->where('meta_key', 'privacy')->where('meta_value', 1);
    			}
    		])
            ->where( 'title', 'like', '%'. $string.'%')
			->where( 'project_id', $project_id )
			->get();

		$items = array_merge( $items, $this->get_items( $tasks, 'task' ));
		
		$board = Board::with([
    			'metas'	=> function( $q ) {
    				$q->where('meta_key', 'privacy')->where('meta_value', 1);
    			}
    		])
            ->where( 'title', 'like', '%'. $string.'%')
			->where( 'project_id', $project_id )
			->get();

		$items = array_merge( $items, $this->get_items( $board, 'board' ));

    	return $items;
    }

    public function get_items( $items, $type ) {
    	$items_array = [];

    	foreach ( $items as $item ) {
    		$result = [];
    		$result['type']  = $type;

    		if ( $type !== 'project' ) {
    			$result['project_id'] = $item->project_id;
    			$project_id =  $item->project_id;
    		} else {
    			$project_id = $item->id;
    		}

			if ( !pm_user_can( 'view_project', $project_id ) ) {
				continue;
			}

    		if ( $type == 'task' ) {
    			if ( isset( $item->metas[0] ) && !pm_user_can( 'view_private_task', $item->project_id ) ) {
    				continue;
    			}
    			

    			if ( $item->parent_id !== "0" ) {
	    			$result['type'] = 'subtask';
	    			$result['parent_id'] = $item->parent_id;
	    		}
    		}
    		
    		if ( $type == 'board' ) {
    			if ( 
    				isset( $item->metas[0] ) 
    				&&  $item->type == 'milestone' 
    				&& !pm_user_can( 'view_private_milestone', $item->project_id )  
    			) {
    				continue ;
    			}
    			if ( 
    				isset( $item->metas[0] ) 
    				&&  $item->type == 'discussion_board' 
    				&& !pm_user_can( 'view_private_message', $item->project_id )  
    			) {
    				continue ;
    			}

    			if ( 
    				isset( $item->metas[0] ) 
    				&&  $item->type == 'task_list' 
    				&& !pm_user_can( 'view_private_list', $item->project_id )  
    			) {
    				continue ;
    			}
    			$result['type'] = $item->type;
    		}
    		
			$result['title'] = $item->title;
			$result['id']    = $item->id;
    		
    		$items_array[] = $result;
    	}

    	return $items_array;
    }
}