<?php
namespace WeDevs\PM_Pro\Reports\Controllers;

use Carbon\Carbon;
use Illuminate\Pagination\Paginator;
use League\Fractal\Pagination\IlluminatePaginatorAdapter;
use League\Fractal\Resource\Collection as Collection;
use WeDevs\PM\Common\Traits\Request_Filter;
use WeDevs\PM\Common\Traits\Transformer_Manager;
use WeDevs\PM\Project\Models\Project;
use WeDevs\PM\Project\Transformers\Project_Transformer;
use WeDevs\PM\Task\Models\Task;
use WeDevs\PM\Task\Transformers\Task_Transformer;
use WP_REST_Request;
use \WeDevs\ORM\Eloquent\Facades\DB;

class Reports_Controller
{

    use Transformer_Manager, Request_Filter;

    public function overdue_tasks(WP_REST_Request $request)
    {
        $per_page = $request->get_param('per_page');
        $page = $request->get_param('page');
        $status = $request->get_param('status');
        $category = $request->get_param('category');
        $project_id = $request->get_param('project_id');
        $user_id = $request->get_param('user_id');

        $per_page_from_settings = pm_get_settings('project_per_page');
        $per_page_from_settings = $per_page_from_settings ? $per_page_from_settings : 15;

        $per_page = $per_page ? $per_page : $per_page_from_settings;
        $page = $page ? $page : 1;
        $today = Carbon::now();
        $estimation = 0;
        $task_count = 0;

        Paginator::currentPageResolver(function () use ($page) {
            return $page;
        });

        $projects = Project::with([
            'task_lists' => function ($task_list) use ($today, $user_id, &$estimation, &$task_count) {
                $task_list->with([
                    'tasks' => function ($task) use ($today, $user_id, &$estimation, &$task_count) {

                        if (!empty($user_id)) {
                            $task = $task->whereHas('assignees', function ($q) use ($user_id) {
                                $q->where('assigned_to', $user_id);
                            });
                        }

                        $task = $task->where('parent_id', 0)
                            ->where('due_date', '<', $today)
                            ->where('status', 0)
                            ->orderBy( pm_tb_prefix() . 'pm_boardables.order', 'ASC' );
                            
                        $estimation = $estimation + (int) $task->sum('estimation');
                        $task_count = $task_count + (int) $task->count();

                    }])
                    ->whereHas('tasks', function ($query) use ($today, $user_id) {

                        if (!empty($user_id)) {
                            $query = $query->whereHas('assignees', function ($q) use ($user_id) {
                                $q->where('assigned_to', $user_id);
                            });
                        }

                        $query->where('parent_id', 0)->where('due_date', '<', $today)->where('status', 0);

                    });
            },
        ])

            ->whereHas('tasks', function ($query) use ($today, $user_id) {

                if (!empty($user_id)) {
                    $query = $query->whereHas('assignees', function ($q) use ($user_id) {
                        $q->where('assigned_to', $user_id);
                    });
                }

                $query->where('parent_id', 0)->where('due_date', '<', $today)->where('status', 0);

            })

            ->orderBy('created_at', 'DESC');

        if (!empty($project_id) && $project_id != -1) {
            $projects = $projects->where('id', $project_id);
        }

        if ($per_page == '-1') {
            $per_page = $projects->count();
        }
        add_filter('pm_project_transformer_default_includes', function ($defaut) {
            return ['task_lists'];
        });
        add_filter('pm_task_list_transformer_default_includes', function ($defaut) {
            return ['tasks'];
        });
        add_filter('pm_task_transformer_default_includes', function ($default) {
            return ['creator', 'assignees'];
        });

        $projects_paginate = $projects->paginate($per_page);

        $project_collection = $projects_paginate->getCollection();
        $resource = new Collection($project_collection, new Project_Transformer);

        $resource->setMeta([
            'total_projects' => $projects->count(),
            'total_result' => (int) $task_count,
            'estimation' => (int) $estimation,
        ]);

        $resource->setPaginator(new IlluminatePaginatorAdapter($projects_paginate));

        return $this->get_response($resource);
    }

    public function completed_tasks(WP_REST_Request $request)
    {
        $per_page = $request->get_param('per_page');
        $page = $request->get_param('page');
        $status = $request->get_param('status');
        $category = $request->get_param('category');
        $project_id = $request->get_param('project_id');
        $user_id = $request->get_param('user_id');

        $per_page_from_settings = pm_get_settings('project_per_page');
        $per_page_from_settings = $per_page_from_settings ? $per_page_from_settings : 15;

        $per_page = $per_page ? $per_page : $per_page_from_settings;
        $page = $page ? $page : 1;

        $estimation = 0;
        $task_count = 0;

        Paginator::currentPageResolver(function () use ($page) {
            return $page;
        });

        $projects = Project::with([
            'task_lists' => function ($task_list) use ($user_id, &$estimation, &$task_count) {
                $task_list->with([
                    'tasks' => function ($tasks) use ($user_id, &$estimation, &$task_count) {
                        if (!empty($user_id)) {
                            $tasks = $tasks->whereHas('assignees', function ($q) use ($user_id) {
                                $q->where('assigned_to', $user_id);
                            });
                        }
                        $tasks = $tasks->where('status', 1)
                            ->orderBy( pm_tb_prefix() . 'pm_boardables.order', 'ASC' );

                        $estimation = $estimation + (int) $tasks->sum('estimation');
                        $task_count = $task_count + (int) $tasks->count();
                    },
                ])
                    ->whereHas('tasks', function ($query) use ($user_id) {
                        if (!empty($user_id)) {
                            $query = $query->whereHas('assignees', function ($q) use ($user_id) {
                                $q->where('assigned_to', $user_id);
                            });
                        }
                        $query->where('status', 1);
                    });
            },
        ])
            ->whereHas('tasks', function ($query) use ($user_id) {
                if (!empty($user_id)) {
                    $query = $query->whereHas('assignees', function ($q) use ($user_id) {
                        $q->where('assigned_to', $user_id);
                    });
                }
                $query->where('status', 1);
            })
            ->orderBy('created_at', 'DESC');

        if (!empty($project_id) && $project_id != -1) {
            $projects = $projects->where('id', $project_id);
        }

        if ($per_page == '-1') {
            $per_page = $projects->count();
        }

        add_filter('pm_project_transformer_default_includes', function ($defaut) {
            return ['task_lists'];
        });
        add_filter('pm_task_list_transformer_default_includes', function ($defaut) {
            return ['tasks'];
        });
        add_filter('pm_task_transformer_default_includes', function ($default) {
            return ['creator', 'assignees'];
        });

        $projects_paginate = $projects->paginate($per_page);

        $project_collection = $projects_paginate->getCollection();
        $resource = new Collection($project_collection, new Project_Transformer);

        $resource->setMeta([
            'total_projects' => $projects->count(),
            'total_result' => (int) $task_count,
            'estimation' => (int) $estimation,
        ]);

        $resource->setPaginator(new IlluminatePaginatorAdapter($projects_paginate));

        return $this->get_response($resource);
    }

    public function user_activities(WP_REST_Request $request)
    {
        $per_page = $request->get_param('per_page');
        $page = $request->get_param('page');
        $project_id = $request->get_param('project_id');
        $user_id = $request->get_param('user_id');
        $start_date = $request->get_param('start_date');
        $end_date = $request->get_param('end_date');

        $per_page_from_settings = pm_get_settings('project_per_page');
        $per_page_from_settings = $per_page_from_settings ? $per_page_from_settings : 15;

        $per_page = $per_page ? $per_page : $per_page_from_settings;
        $page = $page ? $page : 1;

        $user_id = !empty($user_id) ? $user_id : get_current_user_id();

        $estimation = 0;
        $task_count = 0;

        Paginator::currentPageResolver(function () use ($page) {
            return $page;
        });

        $projects = Project::with([
            'task_lists' => function ($task_list) use ($user_id, $start_date, $end_date, &$estimation, &$task_count) {
                $task_list->with([
                    'tasks' => function ($tasks) use ($user_id, $start_date, $end_date, &$estimation, &$task_count) {
                        $tasks = $tasks->where('parent_id', 0);

                        $tasks = $tasks->whereHas('assignees', function ($q) use ($user_id) {
                            $q->where('assigned_to', $user_id);
                        });

                        if (!empty($start_date) && pm_get_settings('task_start_field') === "true") {

                            $start_date = date('Y-m-d', strtotime($start_date));
                            $end_date = empty($end_date) ? data('Y-m-d', strtotime(current_time('mysql'))) : date('Y-m-d', strtotime($end_date));

                            $tasks = $tasks->whereBetween('start_at', [$start_date, $end_date])->orderBy('start_at');

                        } else if (!empty($end_date)) {

                            $end_date = date('Y-m-d', strtotime($end_date));
                            $start_date = empty($start_date) ? data('Y-m-d', strtotime(current_time('mysql'))) : date('Y-m-d', strtotime($start_date));

                            $tasks = $tasks->whereBetween('due_date', [$start_date, $end_date])->orderBy('due_date');

                        }

                        $tasks = $tasks->orderBy( pm_tb_prefix() . 'pm_boardables.order', 'ASC' );

                        $estimation = $estimation + (int) $tasks->sum('estimation');
                        $task_count = $task_count + (int) $tasks->count();
                    },
                ])
                    ->whereHas('tasks', function ($tasks) use ($user_id, $start_date, $end_date) {
                        $tasks = $tasks->where('parent_id', 0);

                        $tasks = $tasks->whereHas('assignees', function ($q) use ($user_id) {
                            $q->where('assigned_to', $user_id);
                        });

                        if (!empty($start_date) && pm_get_settings('task_start_field') === "true") {

                            $start_date = date('Y-m-d', strtotime($start_date));
                            $end_date = empty($end_date) ? data('Y-m-d', strtotime(current_time('mysql'))) : date('Y-m-d', strtotime($end_date));

                            $tasks = $tasks->whereBetween('start_at', [$start_date, $end_date])->orderBy('start_at');

                        } else if (!empty($end_date)) {

                            $end_date = date('Y-m-d', strtotime($end_date));
                            $start_date = empty($start_date) ? data('Y-m-d', strtotime(current_time('mysql'))) : date('Y-m-d', strtotime($start_date));

                            $tasks = $tasks->whereBetween('due_date', [$start_date, $end_date])->orderBy('due_date');

                        }
                    });
            },
        ])
            ->whereHas('tasks', function ($tasks) use ($user_id, $start_date, $end_date) {
                $tasks = $tasks->where('parent_id', 0);

                $tasks = $tasks->whereHas('assignees', function ($q) use ($user_id) {
                    $q->where('assigned_to', $user_id);
                });

                if (!empty($start_date) && pm_get_settings('task_start_field') === "true") {

                    $start_date = date('Y-m-d', strtotime($start_date));
                    $end_date = empty($end_date) ? data('Y-m-d', strtotime(current_time('mysql'))) : date('Y-m-d', strtotime($end_date));

                    $tasks = $tasks->whereBetween('start_at', [$start_date, $end_date])->orderBy('start_at');

                } else if (!empty($end_date)) {

                    $end_date = date('Y-m-d', strtotime($end_date));
                    $start_date = empty($start_date) ? data('Y-m-d', strtotime(current_time('mysql'))) : date('Y-m-d', strtotime($start_date));

                    $tasks = $tasks->whereBetween('due_date', [$start_date, $end_date])->orderBy('due_date');

                }
            });

        if (!empty($project_id) && $project_id != -1) {
            $projects = $projects->where('id', $project_id);
        }

        if ($per_page == '-1') {
            $per_page = $projects->count();
        }

        add_filter('pm_project_transformer_default_includes', function ($defaut) {
            return ['task_lists'];
        });
        add_filter('pm_task_list_transformer_default_includes', function ($defaut) {
            return ['tasks'];
        });
        add_filter('pm_task_transformer_default_includes', function ($default) {
            return ['creator', 'assignees'];
        });

        $projects_paginate = $projects->paginate($per_page);

        $project_collection = $projects_paginate->getCollection();
        $resource = new Collection($project_collection, new Project_Transformer);

        $resource->setMeta([
            'total_projects' => $projects->count(),
            'total_result' => (int) $task_count,
            'estimation' => (int) $estimation,
        ]);

        $resource->setPaginator(new IlluminatePaginatorAdapter($projects_paginate));

        return $this->get_response($resource);
    }

    public function user_tasks(WP_REST_Request $request)
    {
        $per_page = $request->get_param('per_page');
        $page = $request->get_param('page');
        $status = $request->get_param('status');
        $category = $request->get_param('category');
        $project_id = $request->get_param('project_id');
        $user_id = $request->get_param('user_id');
        $start_date = $request->get_param('start_date');
        $end_date = $request->get_param('end_date');
        $task_view = $request->get_param('task_view');

        $per_page_from_settings = pm_get_settings('project_per_page');
        $per_page_from_settings = $per_page_from_settings ? $per_page_from_settings : 15;

        $per_page = 15; //$per_page ? $per_page : $per_page_from_settings;
        $page = $page ? $page : 1;

        Paginator::currentPageResolver(function () use ($page) {
            return $page;
        });

        $user_id = !empty($user_id) ? $user_id : get_current_user_id();

        $task = Task::whereHas('assignees', function ($q) use ($user_id) {
            $q->where('assigned_to', $user_id);
        })
            ->where('parent_id', 0);

        if (!empty($project_id) && $project_id != -1) {
            $task = $task->where(pm_tb_prefix() . 'pm_tasks.project_id', $project_id);
        }

        if (!empty($start_date) && pm_get_settings('task_start_field') === "true") {

            $start_date = date('Y-m-d', strtotime($start_date));
            $end_date = empty($end_date) ? data('Y-m-d', strtotime(current_time('mysql'))) : date('Y-m-d', strtotime($end_date));

            $task = $task->whereBetween('start_at', [$start_date, $end_date])->orderBy('start_at');

        } else if (!empty($end_date)) {

            $end_date = date('Y-m-d', strtotime($end_date));
            $start_date = empty($start_date) ? data('Y-m-d', strtotime(current_time('mysql'))) : date('Y-m-d', strtotime($start_date));

            $task = $task->whereBetween('due_date', [$start_date, $end_date])->orderBy('due_date');

        }
        // $task = $task->orderBy( pm_tb_prefix() . 'pm_boardables.order', 'ASC' );
        $task_paginate = $task->paginate($per_page, ['*']);
        $tasks_collectoin = $task_paginate->getCollection();

        $tasks = $tasks_collectoin->toArray();
        $task_ids = wp_list_pluck($tasks, 'id');
        $estimation = wp_list_pluck($tasks, 'estimation');
        $project_ids = wp_list_pluck($tasks, 'project_id');

        if ($task_view) {

            $resource = new Collection($tasks_collectoin, new Task_Transformer);

            $resource->setMeta([
                'total_projects' => count($project_ids),
                'total_result' => count($task_ids),
                'estimation' => array_sum($estimation),
            ]);

            $resource->setPaginator(new IlluminatePaginatorAdapter($task_paginate));

            return $this->get_response($resource);

        }

        $projects = Project::with([
            'task_lists' => function ($task_list) use ($task_ids) {
                $task_list->with([
                    'tasks' => function ($tasks_query) use ($task_ids) {
                        $tasks_query->whereIn(pm_tb_prefix() . 'pm_tasks.id', $task_ids)
                            ->orderBy( pm_tb_prefix() . 'pm_boardables.order', 'ASC' );
                    },
                ])
                    ->whereHas('tasks', function ($tasks_query) use ($task_ids) {
                        $tasks_query->whereIn(pm_tb_prefix() . 'pm_tasks.id', $task_ids);
                    });
            },
        ])
            ->whereHas('tasks', function ($tasks_query) use ($task_ids) {
                $tasks_query->whereIn(pm_tb_prefix() . 'pm_tasks.id', $task_ids);
            })
            ->get();

        if (!empty($project_id) && $project_id != -1) {
            $projects = $projects->where('id', $project_id);
        }

        add_filter('pm_project_transformer_default_includes', function ($defaut) {
            return ['task_lists'];
        });
        add_filter('pm_task_list_transformer_default_includes', function ($defaut) {
            return ['tasks'];
        });
        add_filter('pm_task_transformer_default_includes', function ($default) {
            return ['creator', 'assignees', 'completer'];
        });

        $resource = new Collection($projects, new Project_Transformer);

        $resource->setMeta([
            'total_projects' => count($project_ids),
            'total_result' => count($task_ids),
            'estimation' => array_sum($estimation),
        ]);

        $resource->setPaginator(new IlluminatePaginatorAdapter($task_paginate));

        return $this->get_response($resource);
    }

    public function project_tasks(WP_REST_Request $request)
    {
        $per_page = $request->get_param('per_page');
        $page = $request->get_param('page');
        $task_status = $request->get_param('task_status');
        $category = $request->get_param('category');
        $project_id = $request->get_param('project_id');

        $per_page_from_settings = pm_get_settings('project_per_page');
        $per_page_from_settings = $per_page_from_settings ? $per_page_from_settings : 15;

        $per_page = $per_page ? $per_page : $per_page_from_settings;
        $page = $page ? $page : 1;

        $estimation = 0;
        $task_count = 0;

        Paginator::currentPageResolver(function () use ($page) {
            return $page;
        });

        $projects = Project::with([
            'task_lists' => function ($task_list) use ($task_status, &$estimation, &$task_count) {
                $task_list->with([
                    'tasks' => function ($tasks) use ($task_status, &$estimation, &$task_count) {
                        $tasks = $tasks->where('parent_id', 0);

                        if (isset($task_status)) {
                            $tasks = $tasks->where('status', $task_status);
                        }

                        $tasks = $tasks->orderBy( pm_tb_prefix() . 'pm_boardables.order', 'ASC' );

                        $estimation = $estimation + (int) $tasks->sum('estimation');
                        $task_count = $task_count + (int) $tasks->count();
                    },
                ])
                    ->whereHas('tasks', function ($tasks) use ($task_status) {
                        $tasks = $tasks->where('parent_id', 0);

                        if (isset($task_status)) {
                            $tasks = $tasks->where('status', $task_status);
                        }
                    });
            },
        ])
            ->whereHas('tasks', function ($tasks) use ($task_status) {
                $tasks = $tasks->where('parent_id', 0);

                if (isset($task_status)) {
                    $tasks = $tasks->where('status', $task_status);
                }
            });

        if (!empty($project_id) && $project_id != -1) {
            $projects = $projects->where('id', $project_id);
        }

        add_filter('pm_project_transformer_default_includes', function ($defaut) {
            return ['task_lists'];
        });
        add_filter('pm_task_list_transformer_default_includes', function ($defaut) {
            return ['tasks'];
        });
        add_filter('pm_task_transformer_default_includes', function ($default) {
            return ['creator', 'assignees'];
        });

        if ($per_page == -1) {
            $per_page = $projects->count();
        }

        $projects_paginate = $projects->paginate($per_page);

        $project_collection = $projects_paginate->getCollection();
        $resource = new Collection($project_collection, new Project_Transformer);

        $resource->setMeta([
            'total_projects' => $projects->count(),
            'total_result' => (int) $task_count,
            'estimation' => (int) $estimation,
        ]);

        $resource->setPaginator(new IlluminatePaginatorAdapter($projects_paginate));

        return $this->get_response($resource);

    }

    public function milestone_tasks(WP_REST_Request $request)
    {
        $per_page = $request->get_param('per_page');
        $page = $request->get_param('page');
        $project_id = $request->get_param('project_id');
        $milestone_id = $request->get_param('milestone_id');

        if (empty($milestone_id)) {
            return $this->get_response(null, [
                'message' => pm_get_text('success_messages.no_element'),
            ]);
        }

        $per_page_from_settings = pm_get_settings('project_per_page');
        $per_page_from_settings = $per_page_from_settings ? $per_page_from_settings : 15;

        $per_page = $per_page ? $per_page : $per_page_from_settings;
        $page = $page ? $page : 1;

        $estimation = 0;
        $task_count = 0;

        Paginator::currentPageResolver(function () use ($page) {
            return $page;
        });

        $projects = Project::with([
            'task_lists' => function ($task_list) use ($milestone_id, &$estimation, &$task_count) {
                $task_list->with([
                    'tasks' => function ($tasks) use (&$estimation, &$task_count) {
                        $tasks = $tasks->where('parent_id', 0)->with('creator', 'assignees');
                        $tasks = $tasks->orderBy( pm_tb_prefix() . 'pm_boardables.order', 'ASC' );
                        $estimation = $estimation + (int) $tasks->sum('estimation');
                        $task_count = $task_count + (int) $tasks->count();
                    },
                ])
                    ->whereExists(function ($query) use ($milestone_id) {
                        $query->select(DB::raw(1))
                            ->from(pm_tb_prefix() . 'pm_boardables')
                            ->whereRaw("board_id=" . $milestone_id . "
                            and board_type='milestone'
                            and boardable_type = 'task_list'
                            and boardable_id=" . pm_tb_prefix() . "pm_boards.id"
                            );
                    });
            },
        ])
            ->where('id', $project_id);

        add_filter('pm_project_transformer_default_includes', function ($defaut) {
            return ['task_lists'];
        });
        add_filter('pm_task_list_transformer_default_includes', function ($defaut) {
            return ['tasks'];
        });
        add_filter('pm_task_transformer_default_includes', function ($default) {
            return ['creator', 'assignees'];
        });

        if ($per_page == -1) {
            $per_page = $projects->count();
        }

        $projects_paginate = $projects->paginate($per_page);

        $project_collection = $projects_paginate->getCollection();
        $resource = new Collection($project_collection, new Project_Transformer);

        $resource->setMeta([
            'total_projects' => $projects->count(),
            'total_result' => (int) $task_count,
            'estimation' => (int) $estimation,
        ]);

        $resource->setPaginator(new IlluminatePaginatorAdapter($projects_paginate));

        return $this->get_response($resource);

    }

    public function unassigned_tasks(WP_REST_Request $request)
    {

        $per_page = $request->get_param('per_page');
        $page = $request->get_param('page');
        $project_id = $request->get_param('project_id');

        $per_page_from_settings = pm_get_settings('project_per_page');
        $per_page_from_settings = $per_page_from_settings ? $per_page_from_settings : 15;

        $per_page = $per_page ? $per_page : $per_page_from_settings;
        $page = $page ? $page : 1;

        $estimation = 0;
        $task_count = 0;

        Paginator::currentPageResolver(function () use ($page) {
            return $page;
        });

        $projects = Project::with([
            'task_lists' => function ($task_list) use (&$estimation, &$task_count) {
                $task_list->with([
                    'tasks' => function ($tasks) use (&$estimation, &$task_count) {
                        $tasks = $tasks->whereDoesntHave('assignees');
                        $tasks = $tasks->orderBy( pm_tb_prefix() . 'pm_boardables.order', 'ASC' );
                        $estimation = $estimation + (int) $tasks->sum('estimation');
                        $task_count = $task_count + (int) $tasks->count();
                    },
                ])
                    ->whereHas('tasks', function ($tasks) {
                        $tasks = $tasks->whereDoesntHave('assignees');
                    });
            },
        ])
            ->whereHas('tasks', function ($tasks) {
                $tasks = $tasks->whereDoesntHave('assignees');
            });

        if (!empty($project_id) && $project_id != -1) {
            $projects = $projects->where('id', $project_id);
        }

        if ($per_page == -1) {
            $per_page = $projects->count();
        }

        add_filter('pm_project_transformer_default_includes', function ($defaut) {
            return ['task_lists'];
        });
        add_filter('pm_task_list_transformer_default_includes', function ($defaut) {
            return ['tasks'];
        });
        add_filter('pm_task_transformer_default_includes', function ($default) {
            return ['creator', 'assignees'];
        });

        $projects_paginate = $projects->paginate($per_page);

        $project_collection = $projects_paginate->getCollection();
        $resource = new Collection($project_collection, new Project_Transformer);

        $resource->setMeta([
            'total_projects' => $projects->count(),
            'total_result' => (int) $task_count,
            'estimation' => (int) $estimation,
        ]);

        $resource->setPaginator(new IlluminatePaginatorAdapter($projects_paginate));

        return $this->get_response($resource);

    }

    public function advance_tasks(WP_REST_Request $request)
    {
        $filters = $request->get_param('filters');
        $per_page = $request->get_param('per_page');
        $page = $request->get_param('page');

        $per_page_from_settings = pm_get_settings('project_per_page');
        $per_page_from_settings = $per_page_from_settings ? $per_page_from_settings : 15;

        $per_page = $per_page ? $per_page : $per_page_from_settings;
        $page = $page ? $page : 1;

        Paginator::currentPageResolver(function () use ($page) {
            return $page;
        });

        $filters = collect($filters);
        $user_ids = $filters->where('skey', 'assigned')->values()->get(0)['svalue'];
        $project_ids = $filters->where('skey', 'project')->values()->get(0)['svalue'];
        $status = $filters->where('skey', 'status')->values()->get(0)['svalue'];
        $payable = $filters->where('skey', 'payable')->values()->get(0)['svalue'];
        $time = $filters->where('skey', 'time')->values()->get(0)['svalue'];
        $start_at = isset($time['start_at']) ? date('Y-m-d', strtotime($time['start_at'])) : '';
        $due_date = isset($time['due_date']) ? date('Y-m-d', strtotime($time['due_date'])) : '';

        $projects = Project::with(
            [
                'task_lists' => function ($task_lists) use ($user_ids, $status, $payable, $time, $start_at, $due_date, &$estimation, &$task_count) {
                    $task_lists->with(
                        [
                            'tasks' => function ($tasks) use ($user_ids, $status, $payable, $time, $start_at, $due_date, &$estimation, &$task_count) {
                                $tasks = $tasks->where('parent_id', 0)->with('creator', 'assignees');

                                if ($user_ids) {
                                    $tasks = $tasks->whereHas('assignees', function ($q) use ($user_ids) {
                                        $q->whereIn('assigned_to', $user_ids);
                                    });
                                }

                                if (!empty($status)) {
                                    $tasks = $tasks->where('status', $status);
                                }

                                if (!empty($payable)) {
                                    $tasks = $tasks->where('payable', $payable);
                                }

                                if (!empty($start_at)) {
                                    $tasks = $tasks->where('start_at', '>=', $start_at);
                                }

                                if (!empty($due_date)) {
                                    $tasks = $tasks->where('due_date', '<=', $due_date);
                                }
                                $tasks = $tasks->orderBy( pm_tb_prefix() . 'pm_boardables.order', 'ASC' );

                                $estimation = $estimation + (int) $tasks->sum('estimation');
                                $task_count = $task_count + (int) $tasks->count();

                            },
                        ]
                    );
                },
            ]
        );

        if ($project_ids) {
            $projects = $projects->whereIn('id', $project_ids);
        }

        if ($per_page == -1) {
            $per_page = $projects->count();
        }

        add_filter('pm_project_transformer_default_includes', function ($defaut) {
            return ['task_lists'];
        });
        add_filter('pm_task_list_transformer_default_includes', function ($defaut) {
            return ['tasks'];
        });
        add_filter('pm_task_transformer_default_includes', function ($default) {
            return ['creator', 'assignees'];
        });

        $projects_paginate = $projects->paginate($per_page);

        $project_collection = $projects_paginate->getCollection();
        $resource = new Collection($project_collection, new Project_Transformer);

        $resource->setMeta([
            'total_projects' => $projects->count(),
            'total_result' => (int) $task_count,
            'estimation' => (int) $estimation,
        ]);

        $resource->setPaginator(new IlluminatePaginatorAdapter($projects_paginate));

        return $this->get_response($resource);
    }

}
