<?php
namespace WeDevs\PM_Pro\Calendar\Controllers;

use WP_REST_Request;
use League\Fractal\Resource\Collection as Collection;
use WeDevs\PM\Common\Traits\Transformer_Manager;
use WeDevs\PM\Task\Models\Task;
use WeDevs\PM\Milestone\Models\Milestone;
use WeDevs\PM\Project\Models\Project;
use Carbon\Carbon;
use WeDevs\PM_Pro\Calendar\Transformers\Calendar_Transformer;
use WeDevs\PM\User\Models\User_Role;


class Calendar_Controller {

    use Transformer_Manager;

    public function index( WP_REST_Request $request ) {

        $project_id = $request->get_param( 'project_id' );
        $start      = $request->get_param( 'start' );
        $end        = $request->get_param( 'end' );
        $events     = array();
        $user_id    = get_current_user_id();
        
        // get user assigness project ids
        if ( $project_id == -1 ) {
            $project_ids = User_Role::where( 'user_id', $user_id)->get(['project_id'])->toArray();
            $project_ids = wp_list_pluck($project_ids, 'project_id');
        }else {
            $project_ids =[$project_id];
        }
        
        $milestones = Milestone::with( 
                [
                    'metas' => function ( $q ) {
                        $q->whereIn( 'meta_key', ['achieve_date', 'status'] );
                    }
                ]
            )
            ->whereIn( 'project_id', $project_ids)
            ->whereHas( 'metas' , function ( $q ) use( $start, $end ) {
                $q->where( function ( $q2 ) use( $start, $end ) {
                    $q2->where( 'meta_key', 'achieve_date' )
                    ->whereBetween( 'meta_value', array($start, $end) )
                    ->orWhereNull( 'meta_value' );
                } );
                
            });

        // Check milseotne is private or not and has permission to show private

        if ( !$this->can_view( 'view_private_milestone', $project_id,  $user_id ) ) {
            $milestones = $milestones->doesntHave('metas', 'and', function( $q ){
                $q->where( 'meta_key', '=', 'privacy' )
                    ->where( 'meta_value', '!=', '0' );
            });
        }
        
        // Task query
        $tasks_query = Task::with('assignees')
            ->parent()
            ->whereIn( 'project_id', $project_ids)
            ->where( function( $query ) use ($start, $end) {

                $query->where( function ( $q2 ) use ($start, $end) {
                    $q2->where( 'start_at', '>=', $start)
                        ->where( 'due_date', '<=', $end );
                })

                ->orWhere( function ( $q3 ) use ($start, $end) {
                    $q3->whereNull( 'due_date' )
                        ->where( function ( $qsub ) use ($start, $end) {
                            $qsub->where( 'start_at', '>=', $start )
                                ->where( 'created_at', '<=', $end );
                        });
                } )

                ->orWhere( function ($q4) use ($start, $end) {
                    $q4->whereNull( 'start_at' )
                        ->where( function ( $qsub ) use ($start, $end) {
                            $qsub->where( 'due_date', '>=', $start )
                                ->where( 'created_at', '<=', $end );
                        });
                } )

                ->orWhere( function( $q5 ) use ($start, $end) {
                    $q5->whereNull( 'start_at' )
                        ->orWhereNull( 'due_date' )
                        ->whereBetween( 'created_at', array($start, $end) );
                } );
            } );

        // Check Task is private or not and has permission to show private

        if ( !$this->can_view( 'view_private_task', $project_id,  $user_id ) ) {

            $tasks_query = $tasks_query->doesntHave('metas', 'and', function( $q ){
                $q->where( 'meta_key', '=', 'privacy' )
                    ->where( 'meta_value', '!=', '0' );
            });

            $tasks_query = $tasks_query->doesntHave( 'task_lists.metas', 'and', function ($query) {
                $query->where( 'meta_key', '=', 'privacy' )
                        ->where( 'meta_value', '!=', '0' );
                });
        }

        $tasks      = $tasks_query->get()->toArray();
        $milestones = $milestones->get()->toArray();
        $events     =  array_merge($tasks, $milestones); //$tasks->concat($milestones);
        $resource   = new Collection( $events, new Calendar_Transformer );
        return $this->get_response( $resource );
    }

    private function can_view( $can, $project_id, $user_id ) {

        if ( pm_has_manage_capability( $user_id ) ){
            return true;
        }

        if ( $project_id != -1  && pm_user_can( $can, $project_id ) ){
            return true;
        }

        return false;
    }
}