<?php

use WeDevs\PM_Pro\Core\Router\Router;
use WeDevs\PM_Pro\Core\Permissions\Administrator;
use WeDevs\PM\Core\Permissions\Create_File;
use WeDevs\PM\Core\Permissions\Access_Project;
$router = Router::singleton();

$router->post( 'projects/{project_id}/files/{file_id}', 'WeDevs/PM_Pro/File/Controllers/File_Controller@update' )
    ->permission(['WeDevs\PM\Core\Permissions\Edit_File']);

$router->post( 'projects/{project_id}/files/{file_id}/delete', 'WeDevs/PM_Pro/File/Controllers/File_Controller@destroy' )
    ->permission(['WeDevs\PM\Core\Permissions\Edit_File']);

$router->post( 'projects/{project_id}/files', 'WeDevs/PM_Pro/File/Controllers/File_Controller@store' )
    ->permission(['WeDevs\PM\Core\Permissions\Create_File']);
$router->get( 'projects/{project_id}/files', 'WeDevs/PM_Pro/File/Controllers/File_Controller@index' )
    ->permission(['WeDevs\PM\Core\Permissions\Access_Project']);



