<?php
/**
 * Module Name: Sub Task
 * Description: Break down your to-dos into smaller tasks for better management and project tracking.
 * Module URI: https://wedevs.com/weforms/
 * Thumbnail URL: /views/assets/images/sub-task.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 */

add_action( 'admin_enqueue_scripts', 'register_sub_task_scripts' );
add_action( 'wp_enqueue_scripts', 'register_sub_task_scripts' );
add_action( 'admin_enqueue_scripts', 'pm_pro_admin_load_sub_task_scripts' );

function register_sub_task_scripts() {

	wp_register_script( 'sub-tasks', plugins_url( 'views/assets/js/sub-tasks.js', __FILE__ ), array('pm-const'), config( 'app.version' ), true );
	wp_register_style( 'sub-tasks', plugins_url( 'views/assets/css/sub-tasks.css', __FILE__ ), array(), config( 'app.version' ) );
}

function pm_pro_admin_load_sub_task_scripts() {
    if (
        isset( $_GET['page'] )
            &&
        $_GET['page'] == 'pm_projects'
    ) {
        pm_pro_enqueue_sub_tasks_script();
    }
}

function pm_pro_enqueue_sub_tasks_script() {
	wp_enqueue_script( 'sub-tasks' );
	wp_enqueue_style( 'sub-tasks' );
}

add_filter( 'pm_pro_load_router_files', function( $files ) {
	$sub_tasks_router_files = glob( __DIR__ . "/routes/*.php" );

	return array_merge( $files, $sub_tasks_router_files );
});

add_filter( 'pm_task_transform', function ( $task_transform ) {
	$task_transform['new_sub_task_form'] = false;
	$task_transform['sub_tasks'] = [];
	$task_transform['sub_task_content'] = false;

	return $task_transform;
});






