<?php

namespace WeDevs\PM_Pro\Core\WP;

use WeDevs\PM_Pro\Core\WP\Output;
use WeDevs\PM_Pro\Core\WP\Enqueue_Scripts;
use WeDevs\PM_Pro\User\Models\User;
use WeDevs\PM\User\Models\User_Role;

class Menu {

	private static $capability = 'read';
	
	public static function admin_menu($home) {
		global $submenu;
		
		$active_task = self::my_task_count();

		$mytask_text = sprintf( __( 'My Tasks %s', 'cpm-pro' ), '<span class="awaiting-mod count-1"><span class="pending-count">' . $active_task . '</span></span>' );

		$submenu['pm_projects']['my_task'] = [ $mytask_text , self::$capability, 'admin.php?page=pm_projects#/my-tasks' ];
		$submenu['pm_projects']['calendar'] = [ __( 'Calendar', 'pm' ), self::$capability, 'admin.php?page=pm_projects#/calendar' ];
		
		$submenu['pm_projects'][] = [ __( 'Modules', 'pm' ), 'administrator', 'admin.php?page=pm_projects#/modules' ];
		
		
		add_action( 'admin_print_styles-' . $home, array( 'WeDevs\\PM_Pro\\Core\WP\\Menu', 'scripts' ) );

		do_action( 'pm_pro_menu', $home );
	}

	public static function scripts() {
		Enqueue_Scripts::scripts();
		Enqueue_Scripts::styles();
	}

	public static function my_task_count () {
		$today = date( 'Y-m-d', strtotime( current_time( 'mysql' ) ) );
		$user_id = get_current_user_id();

		$project_ids = User_Role::where( 'user_id', $user_id)->get(['project_id'])->toArray();
        $project_ids = wp_list_pluck( $project_ids, 'project_id' );
            
        if ( pm_has_manage_capability() ){
            $tasks = User::find( $user_id )
            	->tasks()
                ->parent()
                ->where( pm_tb_prefix() . 'pm_tasks.status', 0)
            	->whereIn( pm_tb_prefix() . 'pm_tasks.project_id', $project_ids)
                ->get();
        }else{
            $tasks = User::find( $user_id )->tasks()
                ->parent()
                ->where( pm_tb_prefix() . 'pm_tasks.status', 0)
                ->whereIn( pm_tb_prefix() . 'pm_tasks.project_id', $project_ids)
                ->doesntHave( 'metas', 'and', function ($query) {
                    $query->where( 'meta_key', '=', 'privacy' )
                        ->where( 'meta_value', '!=', '0' );
                         
                });

            $tasks = $tasks->doesntHave( 'task_lists.metas', 'and', function ($query) {
                $query->where( 'meta_key', '=', 'privacy' )
                        ->where( 'meta_value', '!=', '0' );
                         
                })->get();
        }

        return $tasks->count();
	}
}