<?php

namespace WeDevs\PM_Pro\Core\WP;

use WeDevs\PM_Pro\Core\WP\Menu;
use WeDevs\PM_Pro\Core\WP\Register_Scripts;
use WeDevs\PM_Pro\Core\WP\Enqueue_Scripts as Enqueue_Scripts;
//use PM\Project\Project_Ajax;
use WeDevs\PM_Pro\Core\File_System\File_System as File_System;
use WeDevs\PM_Pro\Core\Notifications\Notification;
use WeDevs\PM_Pro\Core\Update\Update;


class Frontend {

    /**
     * Plan type
     *
     * @var string
     */
    //private $plan = 'project-manager-pro';

    /**
     * Constructor for the PM class
     *
     * Sets up all the appropriate hooks and actions
     * within our plugin.
     */
    public function __construct() {

        $this->includes();
        // instantiate classes
        $this->instantiate();

        // Initialize the action hooks
        $this->init_actions();

        // Initialize the action hooks
        $this->init_filters();
    }

    public function includes() {
        // load all the active modules
        $modules = pm_pro_get_active_modules();
        $modules_path = pm_pro_config('define');

        if ( $modules ) {
            foreach ($modules as $module_file) {
                $module_path = $modules_path['module_path'] . '/' . $module_file;

                if ( file_exists( $module_path ) ) {
                    include_once $module_path;
                }
            }
        }
    }

    /**
     * All actions
     *
     * @return void
     */
    public function init_actions() {
        add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );
        add_action( 'pm_menu_before_load_scripts', array( new Menu, 'admin_menu' ) );
        add_action( 'wp_ajax_pm_ajax_upload', array ( new File_System, 'ajax_upload_file' ) );
        add_action( 'pm_new_message_before_response', 'save_discuss_privacy_field', 10, 2 );
        add_action( 'pm_update_message_before_response', 'save_discuss_privacy_field', 10, 2 );
        add_action( 'pm_new_task_list_before_response', 'save_task_list_privacy_field', 10, 2 );
        add_action( 'pm_update_task_list_before_response', 'save_task_list_privacy_field', 10, 2 );
        add_action( 'pm_after_create_task', 'save_task_privacy_field', 10, 2 );
        add_action( 'pm_after_update_task', 'save_task_privacy_field', 10, 2 );
        add_action( 'pm_new_milestone_before_response', 'save_milestone_privacy_field', 10, 2 );
        add_action( 'pm_update_milestone_before_response', 'save_milestone_privacy_field', 10, 2 );
        add_action( 'admin_enqueue_scripts', array ( $this, 'register_scripts' ) );
        add_action( 'init', array( $this, 'shortcode_instantiate' ) );
        add_action( 'pm_after_save_settings', 'active_daily_digest_event' );
        add_action( 'pm_after_new_project', 'assign_employees_to_project', 10, 2 );
        add_action( 'pm_after_update_project', 'assign_employees_to_project', 10, 2 );
        add_action( 'erp_hr_employee_job_info_create', 'update_erp_department_user', 10, 1);
        add_action( 'erp_hr_dept_before_updated', 'update_erp_department', 10, 2);
    }

    /**
     * load plugin text domain
     * @return [type] [description]
     */
    public function load_plugin_textdomain() {
        load_plugin_textdomain( 'pm-pro', true, pm_pro_config('define.path') . '/languages/' );
    }

    /**
     * All filters
     *
     * @return void
     */
    public function init_filters() {
        add_filter( 'pm_project_transformer', 'pm_get_project_capabilities', 10, 2 );
        add_filter( 'pm_milestone_index_query', 'pm_check_milestone_privacy', 10, 2 );
        add_filter( 'pm_milestone_show_query', 'pm_check_milestone_privacy', 10, 2 );
        add_filter( 'pm_task_index_query', 'pm_check_task_privacy', 10, 2 );
        add_filter( 'pm_task_show_query', 'pm_check_task_privacy', 10, 2 );
        add_filter( 'pm_task_query', 'pm_check_task_privacy', 10, 2 );
        add_filter( 'pm_complete_task_query', 'pm_check_task_privacy', 10, 2 );
        add_filter( 'pm_incomplete_task_query', 'pm_check_task_privacy', 10, 2 );
        add_filter( 'pm_discuss_index_query', 'pm_check_discuss_privacy', 10, 2 );
        add_filter( 'pm_discuss_show_query', 'pm_check_discuss_privacy', 10, 2 );
        add_filter( 'pm_discuss_query', 'pm_check_discuss_privacy', 10, 2 );
        add_filter( 'pm_task_list_index_query', 'pm_check_task_list_privacy', 10, 2 );
        add_filter( 'pm_task_list_show_query', 'pm_check_task_list_privacy', 10, 2 );
        add_filter( 'pm_task_list_query', 'pm_check_task_list_privacy', 10, 2 );
        add_filter( 'pm_get_messages', 'pm_add_create_meta', 10, 2 );
        add_filter( 'pm_get_message', 'pm_add_create_meta', 10, 2 );
        add_filter( 'pm_get_jed_locale_data', 'pm_pro_get_jed_locale_data' );
        add_filter( 'todo_list_text_editor', 'pm_project_text_editor' );
        add_filter( 'erp_hr_employee_single_tabs', 'pm_on_profile_tab' );
        add_filter( 'erp_hr_employee_tab_url', 'pm_employee_task_tab_url', 10, 3 );
        add_filter( 'pm_project_transformer', 'pm_get_project_department', 10, 2 );
        add_filter( 'pm_file_query', 'pm_file_privacy_query', 10, 2 );
    }

    /**
     * instantiate clatask
     * @return void
     */
    public function instantiate() {
        Integrations::init();
        new Notification();

        if ( is_admin() ) {
            new update( pm_pro_config( 'app.plan' ) );
        }
    }

    public function register_scripts() {
        Register_Scripts::scripts();
        Register_Scripts::styles();
    }

    public function shortcode_instantiate() {
        Shortcodes::init();
        //Slack::send_notification();
    }
}
