<?php

namespace WeDevs\PM_Pro\Core\Update;

/**
 * The Updater Class
 */
class Update extends \WeDevs_Updater {

    function __construct( $plan ) {

        $version     = pm_pro_config( 'app.version' );
        $name        = pm_pro_config( 'app.name' );
        $pm_pro_file = pm_pro_config( 'define.pm_pro_file' );
        $product_id  = pm_pro_config( 'app.product_id' );

        parent::__construct( $pm_pro_file, $name, $product_id, $plan, $version );

        $this->api_endpoint    = 'http://api.wedevs.com/';

        if ( ! $this->is_local_server() ) {
            add_action( 'pm_menu_before_load_scripts', array( $this, 'admin_menu' ) );
            //add_action( 'weforms-admin-menu', array( $this, 'admin_menu' ), 10, 2 );
            //add_filter( 'weforms_vue_routes', array( $this, 'vue_routes' ) );
        }
    }

    /**
     * Add admin menu
     *
     * @param  string $hook
     * @param  string $capability
     *
     * @return void
     */
    public function admin_menu( $hook ) {
        global $submenu;

        if ( current_user_can( 'activate_plugins' ) ) {
            $submenu['pm_projects'][] = array( __( 'License', 'pm-pro' ), 'activate_plugins', 'admin.php?page=pm_projects#/license' );
        }
    }

    /**
     * Add license routes into the router
     *
     * @param  array $routes
     *
     * @return array
     */
    public function vue_routes( $routes ) {
        $routes[] = array(
            'path'      => '/license',
            'name'      => 'license',
            'component' => 'License'
        );

        return $routes;
    }

    /**
     * License status checking
     *
     * @return void
     */
    public function weforms_license_status() {
        $data = array(
            'license' => $this->get_license_key(),
            'status'  => $this->get_license_status(),
            'message' => ''
        );

        if ( isset( $data['status']->update ) ) {
            $update = strtotime( $data['status']->update );
            $expired = false;

            if ( time() > $update ) {
                $string  = __( 'has been expired %s ago', 'pm-pro' );
                $expired = true;
            } else {
                $string = __( 'will expire in %s', 'pm-pro' );
            }

            $data['message'] = sprintf( __( 'Your license %s (%s).', 'pm-pro' ), sprintf( $string, human_time_diff( $update, time() ) ), date( 'F j, Y', $update ) );
        }

        wp_send_json_success( $data );
    }

    /**
     * Prompts the user to add license key if it's not already filled out
     *
     * @return void
     */
    function license_enter_notice() {
        if ( $key = $this->get_license_key() ) {
            return;
        }
        ?>
        <div class="error">
            <p><?php printf( __( 'Please <a href="%s">enter</a> your <strong>%s</strong> plugin license key to get regular update and support.', 'pm-pro' ), admin_url( 'admin.php?page=pm_projects#/license' ), $this->name ); ?></p>
        </div>
        <?php
    }
}
