<?php
namespace WeDevs\PM_Pro\Core\Shortcodes;

// use WeDevs\PM_Pro\Modules\invoice\includes\Shortcodes;
// use WeDevs\PM\Core\WP\Enqueue_Scripts;
// use WeDevs\PM_Pro\Core\WP\Enqueue_Scripts as Pro_Enqueue_Scripts;
// use WeDevs\PM\Core\WP\Enqueue_Scripts as PM_Scripts;
use WeDevs\PM\Core\WP\Enqueue_Scripts;
use WeDevs\PM\Core\WP\Register_Scripts;
use WeDevs\PM_Pro\Core\WP\Enqueue_Scripts as Pro_Enqueue_Scripts;
use WeDevs\PM_Pro\Core\WP\Register_Scripts as Pro_Register_Scripts;
/**
 */
class PM_Shortcode {

	/**
	 * Get the shortcode content.
	 *
	 * @param array $atts
	 * @return string
	 */
	public static function get( $atts ) {
		return Shortcodes::shortcode_wrapper( array( __CLASS__, 'output' ), $atts );
	}

	/**
	 * Output the shortcode.
	 *
	 * @param array $atts
	 */
	public static function output( $atts = array() ) {
        if ( !is_user_logged_in() ) {
            wp_login_form( array( 'echo' => true ) );

            return;
        }
		echo '<div id="wedevs-pm"></div>';
		self::scripts();
        
	}

	public static function scripts() {
        //pro scripts
        Pro_Register_Scripts::scripts();
        Pro_Register_Scripts::styles();

        // free scripts
        Register_Scripts::scripts();
        Register_Scripts::styles();

        if( pm_pro_is_module_active( 'sub_tasks/sub_tasks.php' ) ) {
            pm_pro_enqueue_sub_tasks_script();
        }

        if( pm_pro_is_module_active( 'time_tracker/time_tracker.php' ) ) {
            pm_pro_enqueue_time_tracker_script();
        }
        if( pm_pro_is_module_active( 'kanboard/kanboard.php' ) ) {
            pm_pro_enqueue_kanboard_script();
        }
        if( pm_pro_is_module_active( 'gantt/gantt.php' ) ) {
            pm_pro_gantt_script();
        }
        if( pm_pro_is_module_active( 'invoice/invoice.php' ) ) {
            pm_pro_invoice_scripts();
        }

        wp_enqueue_style( 'pm-frontend-style' );
        wp_enqueue_script('pm-frontend-scripts');

        //pro scripts
        Pro_Enqueue_Scripts::scripts();
        Pro_Enqueue_Scripts::styles();

        // free scripts
        Enqueue_Scripts::scripts();
        Enqueue_Scripts::styles();
	}

}