<?php 
namespace WeDevs\PM_Pro\Core\Notifications\Emails;

/**
* Daily Digest Email notification
*/

use WeDevs\PM\Core\Notifications\Email;
use WeDevs\PM_Pro\User\Models\User;
use WeDevs\PM\User\Models\User_Role;

class Daily_Digest extends Email
{
  
    function __construct()
    {
        add_action( 'pm_daily_digest', array( $this, 'daily_digest' ) );
    }

    /**
     * Daily digest email notification function
     * @since 2.0.0
     * 
     * @return void 
     */
    public function daily_digest() {
        if ( !$this->is_daily_digest_enable() ) {
            return;
        }

        $user_ids = User_Role::get(['user_id'])->lists('user_id');//pluck('user_id')->unique();
        $user_ids = array_unique($user_ids);
        $user_ids = array_values($user_ids);
        $users    = User::with( 'projects', 'projects.task_lists', 'projects.task_lists.tasks' )->find( $user_ids );

        $subday        = \Carbon\Carbon::now()->subHours(24);
        $now           = \Carbon\Carbon::now();
        
        $template_name = apply_filters( 'pm_daily_digest_email_template_path', $this->get_template_path( '/html/daily_digest.php' ) );
        $subject       = sprintf( __( '[%s] Daily digest -', 'pm' ), $this->get_blogname() );


        if ( !$users->isEmpty() ) {

            foreach ( $users as $user ) {
                $task_ids    = [];
                $project_ids = [];

                if ( !$this->is_user_enable_daily_digest( $user->ID ) ) {
                    continue ;
                }
                $tasks = $user->tasks()
                    ->where( pm_tb_prefix() . 'pm_tasks.status', 0 )
                    ->where( function ( $query ) use ( $subday, $now ) {

                        $query->where('due_date', '<=', $subday);

                 } )->get()->toArray();

                if ( !empty( $tasks ) ) {
                    $task_ids    = wp_list_pluck( $tasks, 'id' );
                    $project_ids = wp_list_pluck( $tasks, 'project_id' );

                    $message = $this->get_content_html( $template_name, [
                        'user_name'   => $user->display_name,
                        'user_id'     => $user->ID,
                        'projects'    => $user->projects,
                        'project_ids' => $project_ids,
                        'tasks_ids'   => $task_ids,
                    ] );

                    $this->send( $user->user_email, $subject, $message );
                }
            }
        }        
    }

    public function is_user_enable_daily_digest( $user_id ) {
        $status =  get_user_meta( $user_id, '_user_daily_digets_status', true );
        
        if ( empty( $status ) ){
            return true;
        }
        
        return $status === 'on';
    } 

    public function is_daily_digest_enable () {
        return pm_get_settings( 'daily_digest' ) === "true";
    }
}
