<?php if(vinkmag_option('header_show_topbar', 'no') == 'yes'): ?>
<!-- top bar start -->
<section class="top-bar v4">
    <div class="container">
        <div class="row">
            <div class="col-md-8 align-self-center">
                <div class="ts-breaking-news clearfix">
                    <h2 class="breaking-title float-left">
                        <i class="fa fa-bolt"></i> <?php esc_html_e('Breaking News :', 'vinkmag'); ?></h2>
                    <div class="breaking-news-content float-left" id="breaking_slider1">
                        <?php 
                        $the_query = vinkmag_breaking_news_query();

                        if ( $the_query->have_posts() ) :
                            while ( $the_query->have_posts() ) :
                                $the_query->the_post();
                        ?>
                                <div class="breaking-post-content">
                                    <p>
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </p>
                                </div>
                        <?php
                            endwhile;
                            wp_reset_postdata();
                        else:
                            esc_html_e('nothing found', 'vinkmag');
                        endif;
                        ?>
                    </div>
                </div>
            </div>
            <!-- end col-->

            <div class="col-md-4 align-self-center">
                <div class="text-right xs-none">
                    <div class="ts-date-item">
                        <i class="fa fa-clock-o"></i> 
                        <?php echo current_time(get_option('date_format')); ?>
                    </div>
                </div>
            </div>
            <!--end col -->
        </div>
        <!-- end row -->
    </div>
</section>
<!-- end top bar-->
<?php endif; ?>



<section class="header-middle v2 v8">
    <div class="container">
        <div class="row">
            <div class="col-md-4 align-self-center">
                <div class="header-logo">
                    <a href="<?php echo home_url('/'); ?>">
                        <img src="<?php 
                        echo esc_url(
                            vinkmag_src(
                                'general_light_logo',
                                VINKMAG_IMG . '/logo/logo_light.png'
                            )
                        );
                    ?>" alt="<?php bloginfo('name'); ?>">
                    </a>
                </div>
            </div>
            <?php if(vinkmag_option('header_show_banner', 'yes') == 'yes'): ?>
            <div class="col-md-8 align-self-center">
                <div class="banner-img">
                    <?php vinkmag_ad('top_banner', 'banner.jpg'); ?>
                </div>
            </div>
            <!-- col end -->
            <?php endif; ?>
        </div>
        <!-- row  end -->
    </div>
    <!-- container end -->
</section>




<!-- header nav start-->
<header class="navbar-standerd header-bg-white">
    <?php get_template_part( 'template-parts/navigations/nav', 'primary-style5' ); ?>
</header>
<!-- header nav end-->
