<?php if(vinkmag_option('header_show_topbar', 'no') == 'yes'): ?>
		<!-- top bar start -->
		<section class="top-bar bg-dark-item">
			<div class="container">
				<div class="row">
					<div class="col-lg-7 align-self-center md-center-item">
						
						<?php get_template_part( 'template-parts/navigations/nav', 'top' ); ?>
					</div>
					<!-- end col-->

					<div class="col-lg-5 text-right align-self-center">
						<ul class="top-social">
							<li>
                                <?php 
                                $social_links = vinkmag_option('general_social_links', 
									[
										[
											'icon_class' => 'fa fa-facebook', 
											'url' => esc_url('http://facebook.com/xpeedstudio/'),
										]
									]);
                                foreach($social_links as $sl):
                                ?>
                                <a href="<?php echo esc_url($sl['url']); ?>">
                                    <i class="<?php echo esc_attr($sl['icon_class']); ?>"></i>
                                </a>
                                <?php endforeach; ?>
							</li>
							<li class="ts-date">
								<i class="fa fa-clock-o"></i>
								<?php echo current_time(get_option('date_format')); ?>
							</li>
						</ul>
					</div>
					<!--end col -->
				</div>
				<!-- end row -->
			</div>
		</section>
		<!-- end top bar-->
<?php endif; ?>


<!-- ad banner start -->
<section class="header-middle header-white">
    <div class="container">
        <div class="row">
            <div class="col-md-4 align-self-center">
                <div class="header-logo xs-center">
                    <a href="<?php echo home_url('/'); ?>">
						<img src="<?php 
							echo esc_url(
								vinkmag_src(
									'general_main_logo',
									VINKMAG_IMG . '/logo/logo_main.png'
								)
							);
						?>" alt="<?php bloginfo('name'); ?>">
					</a>
                </div>
            </div>
            <?php if(vinkmag_option('header_show_banner', 'yes') == 'yes'): ?>
            <div class="col-md-8 align-self-center">
                <div class="banner-img">
                    <?php vinkmag_ad('top_banner', 'banner.jpg'); ?>
                </div>
            </div>
            <!-- col end -->
            <?php endif; ?>
        </div>
        <!-- row  end -->
    </div>
    <!-- container end -->
</section>



<!-- header nav start-->
<header class="navbar-standerd nav-bg-white">
    <?php get_template_part( 'template-parts/navigations/nav', 'primary-style5' ); ?>
</header>
<!-- header nav end-->
