<?php if(vinkmag_option('header_show_topbar', 'no') == 'yes'): ?>
<!-- top bar start -->
<section class="top-bar v2">
	<div class="container">
		<div class="row">
			<div class="col-lg-8 align-self-center">
				<div class="ts-breaking-news clearfix">
					<h2 class="breaking-title float-left">
						<i class="fa fa-bolt"></i> <?php esc_html_e('Breaking News :', 'vinkmag'); ?></h2>
					<div class="breaking-news-content float-left" id="breaking_slider1">
						<?php 
						$the_query = vinkmag_breaking_news_query();

						if ( $the_query->have_posts() ) :
							while ( $the_query->have_posts() ) :
								$the_query->the_post();
						?>
								<div class="breaking-post-content">
									<p>
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
									</p>
								</div>
						<?php
							endwhile;
							wp_reset_postdata();
						else:
							esc_html_e('nothing found', 'vinkmag');
						endif;
						?>
					</div>
				</div>
			</div>
			<!-- end col-->

			<div class="col-lg-4 text-right align-self-center">
				<ul class="top-social">
					<li>
						<?php 
						$social_links = vinkmag_option('general_social_links', 
										[
											[
												'icon_class' => 'fa fa-facebook', 
												'url' => esc_url('http://facebook.com/xpeedstudio/'),
											]
										]);
						foreach($social_links as $sl):
						?>
						<a href="<?php echo esc_url($sl['url']); ?>">
							<i class="<?php echo esc_attr($sl['icon_class']); ?>"></i>
						</a>
						<?php endforeach; ?>
					</li>
					<li class="ts-subscribe">
						<a href="#"><?php esc_html_e('subscribe', 'vinkmag'); ?></a>
					</li>
				</ul>
			</div>
			<!--end col -->


		</div>
		<!-- end row -->
	</div>
</section>
<!-- end top bar-->



<!-- ad banner start -->
<section class="header-middle v2">
	<div class="container">
		<div class="row">
			<div class="col-lg-4">
				<div class="logo">
				<a href="<?php echo home_url('/'); ?>">
					<img src="<?php 
						echo esc_url(
							vinkmag_src(
								'general_light_logo',
								VINKMAG_IMG . '/logo/logo_light.png'
							)
						);
					?>" alt="<?php bloginfo('name'); ?>">
				</a>
				</div>
			</div>
			<?php if(vinkmag_option('header_show_banner', 'yes') == 'yes'): ?>
			<div class="col-lg-8 align-self-center">
				<div class="banner-img">
					<?php vinkmag_ad('top_banner', 'banner.jpg'); ?>
				</div>
			</div>
			<?php endif; ?>
			<!-- col end -->
		</div>
		<!-- row  end -->
	</div>
	<!-- container end -->
</section>
<!-- ad banner end -->


<!-- header nav start-->
<header class="header-default">
	<div class="container">
		<?php get_template_part( 'template-parts/navigations/nav', 'primary-style1' ); ?>
	</div>
</header>
<!-- header nav end-->
<?php endif; ?>