
<!-- footer area -->
<div class="footer-area">
    <?php
    $social_links = vinkmag_option('general_social_links',[]);
        
        
    if(!empty($social_links)): ?>
    <!-- footer social list start-->
    <div class="ts-footer-social-list">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="footer-logo md-center">
                        <a href="<?php echo home_url('/'); ?>">
                            <img src="<?php 
                                echo esc_url(
                                    vinkmag_src(
                                        'general_main_logo',
                                        VINKMAG_IMG . '/logo/logo_main.png'
                                    )
                                );
                            ?>" alt="<?php bloginfo('name'); ?>">
                        </a>
                    </div>
                    <!-- footer logo end-->
                </div>
                <!-- col end-->

                <div class="col-lg-9 align-self-center">
                    <ul class="footer-social text-right xs-left md-center">
                        <?php 
                        foreach($social_links as $sl):
                            $class = 'ts-' . str_replace('fa fa-', '', $sl['icon_class']);
                        ?>
                        <li class="<?php echo esc_attr($class); ?>">
                            <a href="<?php echo esc_url($sl['url']); ?>">
                                <i class="<?php echo esc_attr($sl['icon_class']); ?>"></i>
                                <span><?php echo esc_html($sl['title']); ?></span>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <!-- col end-->

            </div>
        </div>
    </div>
    <!-- footer social list end-->
    <?php endif; ?>

    
    <?php
    $newslatter = vinkmag_option('footer_newslatter', [
        'footer_show_newslatter' => 'no',
        'yes' => array(
            'footer_newslatter_options' => array(
                'newslatter_title' => esc_html__('Sign up for the Newsletter', 'vinkmag'),
                'newslatter_text' => esc_html__('Join our newsletter and get updates in your inbox. We won’t spam you and we respect your privacy.', 'vinkmag'),
                'newslatter_form_shortcode' => ''
            )
        )
    ]);
    
    
    if($newslatter['footer_show_newslatter'] == 'yes'):
        $newslatter = $newslatter['yes']['footer_newslatter_options']; 
    ?>
    <!-- newslater start -->
    <section class="ts-newslatter">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-10 md-center mx-auto">
                    <div class="ts-newslatter-content">
                        <h2><?php echo vinkmag_kses($newslatter['newslatter_title']); ?></h2>
                        <p><?php echo vinkmag_kses($newslatter['newslatter_text']); ?></p>
                    </div>
                </div>
                <!-- col end-->

                <div class="col-lg-6 col-md-10 align-self-center md-center mx-auto">
                    <div class="newsletter-form">
                        <?php echo do_shortcode($newslatter['newslatter_form_shortcode']); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- newslater end -->
    <?php endif; ?>

    <!-- footer start -->
    <footer class="ts-footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="footer-menu text-center">
                        <?php get_template_part( 'template-parts/navigations/nav', 'footer' ); ?>
                    </div>
                    <div class="copyright-text text-center">
                        <p><?php 
                            $copyright_text = vinkmag_option('footer_copyright', '&copy; 2019, Vinkmag. All rights reserved');

                            echo vinkmag_kses($copyright_text);                                
                        ?></p>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer end -->
</div>
<!-- footer area end-->


