<?php 
// get all options
$sidebar_class = ((vinkmag_option('post_sidebar_layout', 'sidebar-right', true) == 'sidebar-right') && is_active_sidebar('sidebar-right'))
                    ? ['col-lg-9', 'col-lg-3', 'sidebar-right']
                    : ['col-lg-9 max-auto', 'hidden', 'sidebar-none'];

$thumbnail_class = (has_post_thumbnail()) ? 'has-thumbnail' : 'no-thunbnail';

?><!-- single post start -->

<div id="content" class="post-layout-2 <?php echo esc_attr($thumbnail_class); ?>">
    <div class="container">
        <?php if(has_post_thumbnail() && !post_password_required()){
            $thumb_src = get_the_post_thumbnail_url();
        }
        
        ?>

            <?php if(get_post_format() == 'video'): ?>
            <?php 
            $video_url = vinkmag_post_option(get_the_ID(), 'featured_video', '');
            $video_url = vinkmag_video_embed($video_url);?>
            <div class="embed-responsive embed-responsive-16by9">
               <iframe class="embed-responsive-item" src="<?php echo esc_url($video_url); ?>" allowfullscreen>
               </iframe>
            </div>
            <?php else: ?>
            <div 
               class="single-big-img mb-30" 
               style="background-image: url(<?php
                  if(has_post_thumbnail() && !post_password_required()){
                        the_post_thumbnail_url();
                  }else{
                     echo esc_url(vinkmag_option('blog_header_image', VINKMAG_IMG . '/blog/banner_img.jpg'));
                  }
                  ?>)">
            <?php get_template_part( 'template-parts/blogs/post-headers/header', 'style2' ); ?>

            </div>
         <?php endif; ?>

     
        <div class="row">
            <div class="<?php echo esc_attr($sidebar_class[0]); ?>">
                <div class="single-post-wrapper">
                    <?php get_template_part( 'template-parts/blogs/breadcumbs/breadcumb', 'style1' ); ?>
                    <div class="ts-grid-box vinkmag-single content-wrapper">
                        <div class="post-content-area">

                            <?php get_template_part( 'template-parts/blogs/contents/content', 'single' ); ?>
                            <?php get_template_part( 'template-parts/blogs/post-footers/footer', 'style1' ); ?>
                        </div>
                    </div>
                    <?php comments_template(); ?>
                    <?php get_template_part( 'template-parts/blogs/post-footers/footer-popular-post', 'style1' ); ?>
                </div>
            </div>
            <div class="<?php echo esc_attr($sidebar_class[1]); ?>">
                <?php get_sidebar(); ?>
            </div>
        </div>
    </div>
</div>