<?php 
// get all options
$sidebar_class = ((vinkmag_option('post_sidebar_layout', 'sidebar-right', true) == 'sidebar-right') && is_active_sidebar('sidebar-right'))
                    ? ['col-lg-9', 'col-lg-3', 'sidebar-right']
                    : ['col-lg-12', 'hidden', 'sidebar-none'];
$thumbnail_class = (has_post_thumbnail()) ? 'has-thumbnail' : 'no-thunbnail';


?><!-- single post start -->

<div id="content" class="post-layout <?php echo esc_attr($thumbnail_class); ?>">
    <div class="container">
        <div class="row">
            <div class="<?php echo esc_attr($sidebar_class[0]); ?>">
                <div class="single-post-wrapper">
                    <?php get_template_part( 'template-parts/blogs/breadcumbs/breadcumb', 'style1' ); ?>
                    <div class="ts-grid-box vinkmag-single content-wrapper">
                        <?php get_template_part( 'template-parts/blogs/post-headers/header', 'style1' ); ?>
                        <div class="post-content-area">
                            <?php if(has_post_thumbnail() && !post_password_required()): ?>
                                <div class="entry-thumbnail post-media post-image post-featured-image">
                                    <?php if(get_post_format() == 'video'): ?>
                                       <?php 
                                       $video_url = vinkmag_post_option(get_the_ID(), 'featured_video', '');
                                       $video_url = vinkmag_video_embed($video_url);?>
                                       <div class="embed-responsive embed-responsive-16by9">
                                          <iframe class="embed-responsive-item" src="<?php echo esc_url($video_url); ?>" allowfullscreen>
                                          </iframe>
                                       </div>
                                    <?php else: ?>
                                        <?php the_post_thumbnail('full'); ?>
                                    <?php endif; ?>
                                </div>
                                <?php if(get_the_post_thumbnail_caption() != ''): ?>
                                    <p class="text-bg"><?php the_post_thumbnail_caption(); ?></p>
                                <?php else: ?>
                                    <div class="clearfix mb-30"></div>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php get_template_part( 'template-parts/blogs/contents/content', 'single' ); ?>
                            <?php get_template_part( 'template-parts/blogs/post-footers/footer', 'style1' ); ?>
                        </div>
                    </div>
                    <?php comments_template(); ?>
                    <?php get_template_part( 'template-parts/blogs/post-footers/footer-popular-post', 'style1' ); ?>
                </div>
            </div>
            <div class="<?php echo esc_attr($sidebar_class[1]); ?>">
                <?php get_sidebar(); ?>
            </div>
        </div>
    </div>
</div>