
<div class="entry-header">
<?php if(vinkmag_option( 'blog_cat_show', 'yes' ) == 'yes'): ?>
    <?php $categories	 = get_the_category(); if ( !empty( $categories ) ): ?>
        <div class="category-name-list">
            <?php foreach($categories as $category): ?>
                <a 
                    href="<?php echo esc_url( get_category_link($category->cat_ID) ); ?>"
                    class="post-cat" 
                    style="<?php echo esc_attr(vinkmag_cat_style($category->cat_ID)); ?>">
                    <?php echo esc_html( $category->cat_name ); ?>
                </a>
            <?php endforeach; ?>
        </div>
    <?php endif; endif; ?>
    <h2 class="post-title lg"><?php the_title(); ?></h2>

    <ul class="post-meta-info">
        <?php if(vinkmag_option( 'blog_author_show', 'yes' ) == 'yes'): ?>
        <li class="author">
            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                <?php if(vinkmag_option( 'blog_author_image_show', 'yes' ) == 'yes'):?>
                <?php echo get_avatar(get_the_author_meta('ID')); ?> 
                <?php endif; ?>
                <?php echo esc_html(get_the_author_meta('display_name')); ?>
            </a>
        </li>
        <?php endif; ?>
        <?php if(vinkmag_option( 'blog_date_show', 'yes' ) == 'yes'): ?>
        <li>
            <i class="fa fa-clock-o"></i>
            <?php echo get_the_date(); ?>
        </li>
        <?php endif; ?>

        <?php if(vinkmag_option('blog_comment_count_show', 'yes') == 'yes'): ?>
        <li>
            <i class="fa fa-comments"></i>
            <?php
                $num_comments = get_comments_number();

                if ( comments_open() ) {
                    if ( $num_comments == 0 ) {
                        $comments = esc_html__('No Comments', 'vinkmag');
                    } elseif ( $num_comments > 1 ) {
                        $comments = $num_comments . esc_html__(' Comments', 'vinkmag');
                    } else {
                        $comments = esc_html__('1 Comment', 'vinkmag');
                    }
                    echo vinkmag_return($comments);
                } else {
                    $write_comments =  esc_html__('Comments are off', 'vinkmag');
                }           
            ?>
        </li>
        <?php endif; ?>
        <?php if(vinkmag_option('blog_view_count_show', 'yes') == 'yes' && class_exists('Vinkmag_Essentials_Includes')): ?>
        <li class="active">
            <i class="icon-fire"></i>
            <?php echo vinkmag_get_postview(get_the_ID()); ?>
        </li>
        <?php endif; ?>

        <?php if(vinkmag_option('blog_social_share_show', 'yes') == 'yes'): ?>
            <li class="social-share-post">
                <span class="share-post"><i class="fa fa-share"></i></span>
                <?php vinkmag_social_share(); ?>
            </li>
            <?php endif; ?>

            <?php if(vinkmag_option('blog_read_time_show', 'yes') == 'yes'): ?>
            <li>
                <?php echo vinkmag_count_read_time(); ?>
            </li>
            <?php endif; ?>
</div>