<!-- tags cloud start -->
<div class="tagcloud mb-30 post-tag-colud">
    <?php the_tags( sprintf( wp_kses_post( '<strong>Tags:</strong> ', 'vinkmag' )), ' ' ); ?>
</div>
<!-- tags cloud end -->

<?php if(vinkmag_option('blog_author_details_show', 'no') == 'yes'): ?>
    <div class="author-box">
        <?php if(vinkmag_option( 'blog_author_image_show', 'yes' ) == 'yes'):?>
           <?php echo get_avatar(get_the_author_meta('ID')); ?> 
        <?php endif; ?>
        <div class="author-info">
            <h4 class="author-name"><?php echo esc_html(get_the_author_meta('display_name')); ?></h4>
            <p><?php echo esc_html(get_the_author_meta('description')); ?></p>
        </div>
        <div class="clearfix"></div>
    </div>
<?php endif; ?>


<?php 
// Don't print empty markup if there's nowhere to navigate.
$next_post	 = get_next_post();
$pre_post	 = get_previous_post();
if ( $next_post || $pre_post ):
?>
<div class="post-navigation clearfix">
    <div class="post-previous float-left">
        <?php if ( !empty( $pre_post ) ): ?>
            <a href="<?php echo get_the_permalink( $pre_post->ID ); ?>">
                <span><?php esc_html_e( 'Read Previous', 'vinkmag' ) ?></span>
                <p><?php echo get_the_title( $pre_post->ID ); ?></p>
            </a>
        <?php endif; ?>
    </div>
    <div class="post-next float-right">
        <?php if ( !empty( $next_post ) ): ?>
            <a href="<?php echo get_the_permalink( $next_post->ID ); ?>">
                <span><?php esc_html_e( 'Read Next', 'vinkmag' ) ?></span>
                <p><?php echo get_the_title( $next_post->ID ); ?></p>
            </a>
        <?php endif; ?>
    </div>
</div>
<!-- post navigation end-->
<?php endif; ?>