<?php if(vinkmag_option('blog_popular_post_show', 'no') == 'yes'): ?>

    <?php 
    // the query
    $args = [
        'posts_per_page'=>5, 
        'orderby'=>'comment_count', 
        'order'=>'DESC'
    ];
    $the_query = new WP_Query( $args ); ?>

    <?php if ( $the_query->have_posts() ) : ?>

    <div class="ts-grid-box">
        <h2 class="ts-title"><?php esc_html_e('Most Popular', 'vinkmag'); ?></h2>
        <div class="popular-grid-slider owl-carousel">

        <?php while ( $the_query->have_posts() ) : $the_query->the_post(); 
        
            $category = get_the_category();
        ?>
            <div class="item">
                <a 
                    class="post-cat" href="<?php echo esc_url( get_category_link($category[ 0 ]->cat_ID) ); ?>"
                    style="<?php echo esc_attr(vinkmag_cat_style($category[ 0 ]->cat_ID)); ?>">
                        <?php echo esc_html( $category[ 0 ]->cat_name ); ?>
                </a>
                <div class="ts-post-thumb">
                    <a href="<?php the_permalink(); ?>">
                        <img class="img-fluid" src="<?php echo esc_url(vinkmag_post_thumbnail()); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
                    </a>
                </div>
                <div class="post-content">
                    <h3 class="post-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h3>
                    <span class="post-date-info">
                        <i class="fa fa-clock-o"></i>
                        <?php echo get_the_date(); ?>
                    </span>
                </div>
            </div>
        <?php endwhile; ?>
        <?php wp_reset_postdata(); ?>

        </div>
        <!-- most-populers end-->
    </div>
    <?php else : ?>
        <p><?php esc_html_e( 'Nothing found', 'vinkmag' ); ?></p>
    <?php endif; ?>
<?php endif; ?>