<?php
/**
 * content.php
 *
 * The default template for displaying content.
 */
?>

<div <?php post_class('post');?>>

	<?php 
	switch(get_post_format()){
		case 'video':
			$video_url	 	=	vinkmag_post_option( get_the_ID(), 'featured_video' );
			$embed_url	 	=	vinkmag_video_embed($video_url);
			
			$thumbnail_src 	= 	(has_post_thumbnail()) 
								? get_the_post_thumbnail_url( 'post-thumbnail' )
								: vinkmag_youtube_cover($video_url);
								// if empty, returns null
	?>
		<?php fw_print([$video_url, $thumbnail_src]); ?>
	<?php 
		break; 
		case 'audio':
			$soundcloud_url	=	vinkmag_soundcloud_embed(
									vinkmag_post_option( get_the_ID(), 'featured_audio' )
								);
	?>
		<?php fw_print([$soundcloud_url]); ?>
	<?php 
		break; 
		default:
			if ( has_post_thumbnail() ) :
	?>
			
			<div class="post-media">
				<?php the_post_thumbnail( 'post-thumbnail' ); ?>
			</div>
			
	<?php
			endif;
		break;
	}
	?>
	<div class="post-body">
		<div class="entry-header">
			<h2 class="entry-title">
				
			<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			<?php if ( is_sticky() ) {
				echo '<span class="meta-featured-post sticky"> <i class="fa fa-thumb-tack"></i> ' . esc_html__( 'Featured', 'vinkmag' ) . ' </span>';
			} ?>
		</h2>
			<?php //vinkmag_post_meta(); ?>
			<div class="entry-content">
				<?php vinkmag_excerpt( '35' ); ?>
			</div>
		</div>
	</div>
</div>