<?php
/**
 * content.php
 *
 * The default template for displaying content.
 */

$blog_author_show = (isset($settings['show_author'])) 
						? $settings['show_author'] 
						: vinkmag_option( 'blog_author_show', 'yes' );
						
$blog_author_image_show = (isset($settings['show_author_image'])) 
						? $settings['show_author_image'] 
						: vinkmag_option( 'blog_author_image_show', 'yes' );

$blog_date_show			= (isset($settings['show_date'])) 
						? $settings['show_date'] 
						: vinkmag_option( 'blog_date_show', 'yes' );
$blog_cat_show			= (isset($settings['show_cat'])) 
						? $settings['show_cat'] 
						: vinkmag_option( 'blog_cat_show', 'yes' );
// $words 					= (isset($words)) ? $words : 15;

$crop					= (isset($settings['post_title_crop']))
						? $settings['post_title_crop']
                  : 200;
$desc_limit			= (isset($settings['desc_limit']))
						? $settings['desc_limit']
                  : 35;
?>


		<?php require VINKMAG_THEME_DIR . '/template-parts/blogs/post-meta/meta-thumb-only.php'; ?>
		<div class="post-content">
		<?php require VINKMAG_THEME_DIR . '/template-parts/blogs/post-meta/meta-cat-only.php'; ?>

		<h3 class="post-title">
          <a href="<?php the_permalink(); ?>"><?php echo esc_html(vinkmag_limited_title(get_the_title(), $crop)); ?></a>		
      </h3>
		<ul class="post-meta-info">
			<?php if($blog_author_show == 'yes'): ?>
			<li class="author">
				<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
					<?php if($blog_author_image_show == 'yes'):?>
						<?php echo get_avatar(get_the_author_meta('ID')); ?>
					<?php endif; ?>
					<?php echo esc_html(get_the_author_meta('display_name')); ?>
				</a>
			</li>
			<?php endif; ?>
			<?php if($blog_date_show == 'yes'): ?>
			<li>
				<i class="fa fa-clock-o"></i><?php echo get_the_date(); ?>
			</li>
			<?php endif; ?>
		</ul>
	</div>