<?php
/**
 * content.php
 *
 * The default template for displaying content.
 */

$blog_author_show = (isset($settings['show_author'])) 
						? $settings['show_author'] 
						: vinkmag_option( 'blog_author_show', 'yes' );
						
$blog_author_image_show = (isset($settings['show_author_image'])) 
						? $settings['show_author_image'] 
						: vinkmag_option( 'blog_author_image_show', 'yes' );

$blog_date_show			= (isset($settings['show_date'])) 
						? $settings['show_date'] 
						: vinkmag_option( 'blog_date_show', 'yes' );
$blog_cat_show			= (isset($settings['show_cat'])) 
						? $settings['show_cat'] 
						: vinkmag_option( 'blog_cat_show', 'yes' );
// $words 					= (isset($words)) ? $words : 15;
$crop 					= (isset($settings['post_title_crop'])) ? $settings['post_title_crop'] : 100;
$desc_limit			= (isset($settings['desc_limit']))
						? $settings['desc_limit']
                  : 35;

$cat = get_the_category();
?>
<div <?php post_class("heighlight"); ?> style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id)); ?>">
	<div class="item">
	
		<div class="ts-post-thumb">
			<a href="<?php the_permalink() ?>">
				<img 
					class="img-fluid" 
					src="<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID())); ?>" 
					alt="<?php echo esc_attr(vinkmag_alt(get_the_ID())); ?>">
			</a>
			<?php if($blog_cat_show == 'yes'): ?>
				<a 
					class="post-cat" 
					href="<?php echo get_category_link($cat[0]->term_id); ?>"
					style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id)); ?>"
					>
					<span style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id)); ?>"></span>
					<?php echo get_cat_name($cat[0]->term_id); ?>
				</a>
			<?php endif; ?>
		</div>
		<div class="post-content">
		
			<h3 class="post-title">
				<a href="<?php the_permalink(); ?>"><?php echo esc_html(vinkmag_limited_title(get_the_title(), $crop)); ?></a>
			</h3>
			<ul class="post-meta-info">
				<?php if($blog_author_show == 'yes'): ?>
				<li class="author">
					<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
						<?php if($blog_author_image_show == 'yes'):?>
							<?php echo get_avatar(get_the_author_meta('ID')); ?>
						<?php endif; ?>
						<?php echo esc_html(get_the_author_meta('display_name')); ?>
					</a>
				</li>
				<?php endif; ?>
				<?php if($blog_date_show == 'yes'): ?>
				<li>
					<i class="fa fa-clock-o"></i><?php echo get_the_date(); ?>
				</li>
				<?php endif; ?>
			</ul>
			<p>
				<?php vinkmag_excerpt($desc_limit	); ?>
			</p>
		</div>
	</div>
</div>