<?php
/**
 * content.php
 *
 * The default template for displaying content.
 */
$blog_author_show = (isset($settings['show_author'])) 
						? $settings['show_author'] 
						: vinkmag_option( 'blog_author_show', 'yes' );
						
$blog_author_image_show = (isset($settings['show_author_image'])) 
						? $settings['show_author_image'] 
                  : vinkmag_option( 'blog_author_image_show', 'yes' );

$show_view_count	= (isset($settings['show_view_count'])) 
						? $settings['show_view_count'] 
                  : vinkmag_option( 'show_view_count', 'yes' );

$blog_date_show			= (isset($settings['show_date'])) 
						? $settings['show_date'] 
						: vinkmag_option( 'blog_date_show', 'yes' );
 $blog_cat_show			= (isset($settings['show_cat'])) 
						? $settings['show_cat'] 
						: vinkmag_option( 'blog_cat_show', 'yes' );
$thumb 					= (isset($thumb))
						? $thumb
                  : [600, 398];

?>
<div <?php post_class("ts-overlay-style featured-post"); ?>>
<div class="item" style="background-image:url(<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID(), $thumb[0], $thumb[1])); ?>)">
   <a class="img-link" href="<?php the_permalink(); ?>"></a>
   <div class="overlay-post-content">
      <div class="post-content">
      <?php if($blog_cat_show == 'yes'): ?> 
         <?php $cat = get_the_category(); ?>
         <a 
            class="post-cat" 
            href="<?php echo get_category_link($cat[0]->term_id); ?>"
            style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id)); ?>"
            >
            <?php echo get_cat_name($cat[0]->term_id); ?>
         </a>
      <?php endif; ?>

         <h3 class="post-title">
            <a href="<?php the_permalink(); ?>">
            <?php echo esc_html(get_the_title()); ?>
            </a>
         </h3>
         <ul class="post-meta-info">
            <?php if($blog_author_show == 'yes'): ?>
            <li class="author">
               <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                  <?php if($blog_author_image_show == 'yes'):?>
                     <?php echo get_avatar(get_the_author_meta('ID')); ?>
                  <?php endif; ?>
                  <?php echo esc_html(get_the_author_meta('display_name')); ?>
               </a>
            </li>
            <?php endif; ?>
            <?php if($blog_date_show == 'yes'): ?>
            <li>
               <i class="fa fa-clock-o"></i><?php echo get_the_date(); ?>
            </li>
            <?php endif; ?>

            <?php if($show_view_count=='yes'): ?>
               <li class="active">
                  <i class="icon-fire"></i>
                  <?php echo vinkmag_get_postview(get_the_ID()); ?>
               </li>
            <?php endif; ?>

         </ul>
      </div>
   </div>
</div>
</div>