<?php
/**
 * content.php
 *
 * The default template for displaying content.
 */

$blog_author_show = (isset($settings['show_author'])) 
						? $settings['show_author'] 
						: vinkmag_option( 'blog_author_show', 'yes' );
						
$blog_author_image_show = (isset($settings['show_author_image'])) 
						? $settings['show_author_image'] 
						: vinkmag_option( 'blog_author_image_show', 'yes' );

$blog_date_show			= (isset($settings['show_date'])) 
						? $settings['show_date'] 
						: vinkmag_option( 'blog_date_show', 'yes' );
$blog_cat_show			= (isset($settings['show_cat'])) 
						? $settings['show_cat'] 
                  : vinkmag_option( 'blog_cat_show', 'yes' );
                  
$show_view_count			= (isset($settings['show_view_count'])) 
						? $settings['show_view_count'] 
						: vinkmag_option( 'show_view_count', 'yes' );


$crop					= (isset($settings['post_title_crop']))
						? $settings['post_title_crop']
                  : 200;
$desc_limit			= (isset($settings['desc_limit']))
						? $settings['desc_limit']
                  : 35;

$shadow_opt			= (isset($settings['shadow_opt']))
						? $settings['shadow_opt']
				  : '';

$desc_limit = vinkmag_desc_limit($desc_limit);
?>
<div class="ts-grid-box ts-grid-content <?php echo esc_attr(($shadow_opt == 'yes') ? '' : 'grid-no-shadow'); ?>">
	<?php require VINKMAG_THEME_DIR . '/template-parts/blogs/post-meta/meta-cat-thumb.php'; ?>
	<div class="post-content">
		<h3 class="post-title">
			<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
		</h3>
		<ul class="post-meta-info">
			<?php if($blog_author_show == 'yes'): ?>
			<li class="author">
				<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
					<?php if($blog_author_image_show == 'yes'):?>
						<?php echo get_avatar(get_the_author_meta('ID')); ?> 
					<?php endif; ?>
					<?php echo esc_html(get_the_author_meta('display_name')); ?>
				</a>
			</li>
			<?php endif; ?>
			<?php if($blog_date_show == 'yes'): ?>
			<li>
				<i class="fa fa-clock-o"></i><?php echo get_the_date(); ?>
			</li>
         <?php endif; ?>

         <?php if($show_view_count == 'yes') : ?>
         <li class="active">
             <i class="icon-fire"></i>
             <?php echo vinkmag_get_postview(get_the_ID()); ?>
         </li>
         <?php endif; ?>
         
		</ul>
		<?php  ?>
		<p>
			<?php vinkmag_excerpt($desc_limit); ?>
		</p>
	</div>
</div>