<?php
/**
 * content.php
 *
 * The default template for displaying content.
 */



$blog_date_show			= (isset($settings['show_date'])) 
						? $settings['show_date'] 
						: vinkmag_option( 'blog_date_show', 'yes' );

// $words 					= (isset($words)) ? $words : 15;

$crop					= (isset($settings['post_title_limit']))
						? $settings['post_title_limit']
                  : 200;


?>

<div class="ts-col-box-item">
	<div class="ts-post-thumb">
		<a href="<?php the_permalink() ?>">
			<img 
				class="img-fluid" 
				src="<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID())); ?>" 
				alt="<?php echo esc_attr(vinkmag_alt(get_the_ID())); ?>">
		</a>
	</div>
	<div class="post-content">
		<h3 class="post-title">
			<a href="<?php the_permalink(); ?>"><?php echo esc_html(vinkmag_limited_title(get_the_title(), $crop)); ?></a>
		</h3>
		<ul class="post-meta-info">

			<?php if($blog_date_show == 'yes'): ?>
			<li>
				<i class="fa fa-clock-o"></i><?php echo get_the_date(); ?>
			</li>
         <?php endif; ?>
		</ul>
	</div>
</div>