<?php
/**
 * content.php
 *
 * The default template for displaying content.
 */

$blog_author_show = (isset($settings['show_author'])) 
						? $settings['show_author'] 
						: vinkmag_option( 'blog_author_show', 'yes' );
						
$blog_author_image_show = (isset($settings['show_author_image'])) 
						? $settings['show_author_image'] 
						: vinkmag_option( 'blog_author_image_show', 'yes' );

$blog_date_show			= (isset($settings['show_date'])) 
						? $settings['show_date'] 
						: vinkmag_option( 'blog_date_show', 'yes' );
$blog_cat_show			= (isset($settings['show_cat'])) 
						? $settings['show_cat'] 
                  : vinkmag_option( 'blog_cat_show', 'yes' );
                  
$crop					= (isset($settings['post_title_crop']))
						? $settings['post_title_crop']
                  : 200;

$desc_limit			= (isset($settings['desc_limit']))
						? $settings['desc_limit']
                  : 35;
?>

<div <?php post_class('ts-grid-box ts-col-box grid-only-text'); ?>>
	<div class="item">
	<?php if($blog_cat_show == 'yes'): $cat = get_the_category(); ?>
		<a 
			class="post-cat" 
			href="<?php echo get_category_link($cat[0]->term_id); ?>"
			style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id)); ?>"
			>
			<?php echo get_cat_name($cat[0]->term_id); ?>
		</a>
	<?php endif; ?>

		<div class="post-content">
			<h3 class="post-title">
				<a href="<?php the_permalink(); ?>"><?php echo esc_html(vinkmag_limited_title(get_the_title(), $crop)); ?></a>
			</h3>
	
			<p>
				<?php vinkmag_excerpt($desc_limit); ?>
			</p>
			<ul class="post-meta-info">
				<?php if($blog_author_show == 'yes'): ?>
				<li class="author">
					<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
						<?php if($blog_author_image_show == 'yes'):?>
							<?php echo get_avatar(get_the_author_meta('ID')); ?>
						<?php endif; ?>
						<?php echo esc_html(get_the_author_meta('display_name')); ?>
					</a>
				</li>
            <?php endif; ?>
            <li>
               <?php if($blog_date_show == 'yes'): ?>
                  <span class="post-date-info">
                     <i class="fa fa-clock-o"></i> <?php echo get_the_date(); ?>
                  </span>
               <?php endif; ?>
            </li>
			</ul>
		</div>
	</div>
</div>