<?php
/**
 * content.php
 *
 * The default template for displaying content.
 */

$blog_author_show = (isset($settings['show_author'])) 
						? $settings['show_author'] 
						: vinkmag_option( 'blog_author_show', 'yes' );
						
$blog_author_image_show = (isset($settings['show_author_image'])) 
						? $settings['show_author_image'] 
						: vinkmag_option( 'blog_author_image_show', 'yes' );

$blog_date_show			= (isset($settings['show_date'])) 
						? $settings['show_date'] 
						: vinkmag_option( 'blog_date_show', 'yes' );
$blog_cat_show			= (isset($settings['show_cat'])) 
						? $settings['show_cat'] 
						: vinkmag_option( 'blog_cat_show', 'yes' );

$crop					= (isset($settings['post_title_crop']))
						? $settings['post_title_crop']
                  : 200;
$desc_limit			= (isset($settings['desc_limit']))
						? $settings['desc_limit']
                  : 35;
$shadow_opt			= (isset($settings['shadow_opt']))
						? $settings['shadow_opt']
                  : '';
// post description
$desc_limit = vinkmag_desc_limit($desc_limit);

$post_class = (($shadow_opt == 'yes') ? '' : esc_attr('grid-no-shadow')).'ts-grid-box ts-grid-content default-content';
?>
<?php if(is_sticky()){
  ?>
   <span class="meta-featured-post"><i class="fa fa-thumb-tack"></i> <?php esc_html_e('Sticky', 'vinkmag'); ?>  </span>
  <?php
} ?>
<div <?php post_class($post_class); ?>>
	<?php require VINKMAG_THEME_DIR . '/template-parts/blogs/post-meta/meta-thumb-only.php'; ?>
	<div class="post-content">
	
		<ul class="post-meta-info">
      <?php if($blog_author_show == 'yes'): ?>
			<li>
            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                <i class="fa fa-user"></i>
					<?php echo esc_html(get_the_author_meta('display_name')); ?>
				</a>
			</li>
			<?php endif; ?>
			
			<?php if($blog_date_show == 'yes'): ?>
			<li>
				<i class="fa fa-clock-o"></i><?php echo get_the_date(); ?>
			</li>
			<?php endif; ?>
      </ul>
      <h3 class="post-title">
			<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
      </h3>
      
		<p>
			<?php vinkmag_excerpt($desc_limit); ?>
      </p>
      <a href="<?php the_permalink(); ?>" class="read-more-btn"><?php esc_html_e('Read More', 'vinkmag'); ?></a>
	</div>
</div>