<?php 
$category = get_queried_object();
$sidebar_class = ['col-lg-8', 'col-lg-4', 'sidebar-right'];
if(isset($category->cat_ID) && vinkmag_term_option($category->cat_ID, 'block_sidebar_layout', 'sidebar-right') == 'sidebar-none'  || !is_active_sidebar('sidebar-right')){
    $sidebar_class = ['col-lg-9 mx-auto', 'hidden', 'sidebar-none'];
}

?>

<!-- post wraper start-->
<section class="block-wrapper mt-15 personal-blog">
    <div class="container">
        <!-- featured post -->
        <div class="row">
            <div class="col-lg-12 featured-tab-item">
            <?php
                 $sticky = get_option( 'sticky_posts' );
               
                 $args = array(
                     'post_type' => 'post',
                     'posts_per_page' => 3,
                     'post__in' => $sticky,
                 );
                 $query = new WP_Query( $args );
                 
                 ?>
                
                 <div class="tab-content">
                    <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++; ?>
                        <div class="tab-pane fade <?php echo esc_attr(($i == 1) ? 'show active' : ''); ?>" id="nav-post-tab-<?php echo esc_attr($i); ?>"> 
                            <div class="feauted-tab-img">
                                <a href="<?php the_permalink(); ?>">
                                    <?php if(has_post_thumbnail()){
                                        the_post_thumbnail();
                                    } ?>
                                </a>
                            </div>
                        </div>
                    <?php endwhile; 
                    wp_reset_query(); ?>

                </div>
                <!-- Nav tabs -->
                <ul class="nav nav-tabs row featured-tab-post" role="tablist">
                    <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++; ?>
                        <li role="presentation" class="col-lg">
                            <a class="nav-item nav-link <?php echo esc_attr(($i == 1) ? 'active' : ''); ?>" href="#nav-post-tab-<?php echo esc_attr($i); ?>"
                            aria-controls="nav-post-tab-<?php echo esc_attr($i)?>" role="tab" data-toggle="tab">
                                <div class="post-content">
                                    <h3 class="post-title">
                                        <?php the_title(); ?>
                                    </h3>
                                    <ul class="post-meta-info">
                                        <li class="cat-name">
                                          <?php   
                                             $cat = get_the_category(); ?>
                                             <?php echo get_cat_name($cat[0]->term_id); ?>
                                        </li>
                                        <li>
                                            <?php echo get_the_date(); ?>
                                        </li>
                                    </ul>
                                </div>
                            </a>
                        </li>
                    <?php endwhile; ?>
                </ul>

            </div>
        </div>
        <div class="row mb-40">
            <?php 
                $featured_cats = vinkmag_option('featured_categories', '');
                $featured_cats_array = explode(',', $featured_cats);
                if(is_array($featured_cats_array) && !empty($featured_cats_array)): 
                    foreach($featured_cats_array  as $cat_slug): 
                        $cat_data =  get_category_by_slug($cat_slug);
                        if($cat_data != null):
                            $cat_thumbnail = vinkmag_term_option($cat_data->term_id, 'featured_upload_img', '', 'category', true);
                            
                            if(isset($cat_thumbnail['url'])): ?>

    

                
                    <div class="col-md-4">
                        <div class="item">
                            <div class="ts-post-thumb">
                                <img class="img-fluid" src=" <?php echo $cat_thumbnail['url']; ?>" alt="">


                                <a href="<?php echo get_category_link($cat_data->term_id); ?>" class="view-link-btns">
                                    <span><?php echo get_cat_name($cat_data->term_id); ?></span>
                                </a>

                            </div>
                        </div>
                    </div>
               


                <?php endif; endif; endforeach; endif; ?>
                </div>
                

       <div class="row">
            <div class="<?php echo esc_attr($sidebar_class[0]); ?>">
          
            
				<?php if ( have_posts() ) : ?>
                    <div class="row">
                        <?php while ( have_posts() ) : the_post(); ?>
                            <div class="col-md-6 mb-30">
                                <div <?php post_class("grid-md ts-grid-box ts-grid-content"); ?>>
                                    <?php get_template_part( 'template-parts/blogs/contents/content', 'style8' ); ?>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <?php get_template_part( 'template-parts/blogs/paginations/pagination', 'style1' ); ?>
                    
				<?php else : ?>
					<?php get_template_part( 'template-parts/blogs/contents/content', 'none' ); ?>
				<?php endif; ?>

            </div>
            <div class="<?php echo esc_attr($sidebar_class[1]); ?>">
                    <div class="right-sidebar">
                        <?php get_sidebar(); ?>
                    </div>
            </div>
        </div>
    </div>
</section>