<?php 
$category = get_queried_object();
$sidebar_class = ['col-lg-9', 'col-lg-3', 'sidebar-right'];
if(isset($category->cat_ID) && vinkmag_term_option($category->cat_ID, 'block_sidebar_layout', 'sidebar-right') == 'sidebar-none'  || !is_active_sidebar('sidebar-right')){
    $sidebar_class = ['col-lg-9 mx-auto', 'hidden', 'sidebar-none'];
}
?>

<!-- post wraper start-->
<section class="block-wrapper mt-15 category-layout-2">
    <div class="container">
        <div class="row">
            <div class="<?php echo esc_attr($sidebar_class[0]); ?>">
                <div class="ts-grid-box">
                    <?php get_template_part( 'template-parts/blogs/breadcumbs/breadcumb-style', 'category' ); ?>
                    <?php get_template_part( 'template-parts/blogs/category-headers/headers' ); ?>
                </div>

				<?php if ( have_posts() ) : ?>

                    <div class="row">
                        <?php while ( have_posts() ) : the_post(); 
                            if($wp_query->current_post % 3 == 0 && $wp_query->current_post > 1): ?>
                                <div class="col-lg-12">
                                    <?php vinkmag_ad('category_post_banner', 'banner.jpg'); ?>
                                </div>
                            <?php endif; ?>
                            <div class="col-lg-4 col-md-6 mb-30">
                                <div <?php post_class("grid-sm"); ?>>
                                    <?php get_template_part( 'template-parts/blogs/contents/content', 'style1' ); ?>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <?php get_template_part( 'template-parts/blogs/paginations/pagination', 'style1' ); ?>
                    
				<?php else : ?>
					<?php get_template_part( 'template-parts/blogs/contents/content', 'none' ); ?>
				<?php endif; ?>

            </div>
            <div class="<?php echo esc_attr($sidebar_class[1]); ?>">
                    <div class="right-sidebar">
                        <?php get_sidebar(); ?>
                    </div>
            </div>
        </div>
    </div>
</section>