<?php 
$category = get_queried_object();
$sidebar_class = ['col-lg-8', 'col-lg-4', 'sidebar-right'];
if(isset($category->cat_ID) && vinkmag_term_option($category->cat_ID, 'block_sidebar_layout', 'sidebar-right') == 'sidebar-none' || !is_active_sidebar('sidebar-right')){
    $sidebar_class = ['col-lg-12', 'hidden', 'sidebar-none'];
}

?>

<!-- post wraper start-->
<section class="block-wrapper mt-15 category-layout-1">
    <div class="container">
        <div class="row">
            <div class="<?php echo esc_attr($sidebar_class[0]); ?>">
                <?php if(!is_home()): ?>
                    <div class="ts-grid-box">
                        <?php get_template_part( 'template-parts/blogs/breadcumbs/breadcumb-style', 'category' ); ?>
                        <?php get_template_part( 'template-parts/blogs/category-headers/headers' ); ?>
                    </div>
                <?php endif; ?>

                <?php if ( have_posts() ) : ?>
                    <?php while ( have_posts() ) : the_post(); ?>
                        <div <?php post_class("grid-md mb-30"); ?>>
                            <?php get_template_part( 'template-parts/blogs/contents/content', 'default' ); ?>
                        </div>
                    <?php endwhile; ?>
                    <?php get_template_part( 'template-parts/blogs/paginations/pagination', 'style1' ); ?>
				<?php else : ?>
					<?php get_template_part( 'template-parts/blogs/contents/content', 'none' ); ?>
				<?php endif; ?>

            </div>
            <div class="<?php echo esc_attr($sidebar_class[1]); ?>">
                <div class="right-sidebar">
                    <?php get_sidebar(); ?>
                </div>
            </div>
        </div>
    </div>
</section>