<?php
if(vinkmag_option( 'blog_breadcrumb_show', 'yes' ) == 'yes'):
	$word = vinkmag_option( 'blog_breadcrumb_length', 3 );
    $seperator = '';
	if ( !is_home() ) {
		echo '<ol class="ts-breadcrumb">';
		echo '<li><a href="';
		echo esc_url( get_home_url( '/' ) );
		echo '">';
		echo esc_html__( 'Home', 'vinkmag' );
		echo "</a></li> " . esc_attr( $seperator );
		if ( is_category() || is_single() ) {
			echo '<li>';
			$category	 = get_the_category();
			$post		 = get_queried_object();
			$postType	 = get_post_type_object( get_post_type( $post ) );
			if ( !empty( $category ) ) {
				echo '<a href="' . esc_url( get_category_link($category[ 0 ]->cat_ID) ) . '">';
                echo esc_html( $category[ 0 ]->cat_name ) . '</a></li>';
			} else if ( $postType ) {
				echo esc_html( $postType->labels->singular_name ) . '</li>';
			}

			if ( is_single() ) {
				echo esc_attr( $seperator ) . "  <li>";
				echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
				echo '</li>';
			}
		} elseif ( is_page() ) {
			echo '<li>';
			echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
			echo '</li>';
		}

		if ( is_tag() ) {
			echo '<li>';
				single_tag_title();
			echo '</li>';
		} elseif ( is_day() ) {
			echo"<li>" . esc_html__( 'Blogs for', 'vinkmag' ) . " ";
			the_time( 'F jS, Y' );
			echo'</li>';
		} elseif ( is_month() ) {
			echo"<li>" . esc_html__( 'Blogs for', 'vinkmag' ) . " ";
			the_time( 'F, Y' );
			echo'</li>';
		} elseif ( is_year() ) {
			echo"<li>" . esc_html__( 'Blogs for', 'vinkmag' ) . " ";
			the_time( 'Y' );
			echo'</li>';
		} elseif ( is_author() ) {
			echo"<li>" . esc_html__( 'Author Blogs', 'vinkmag' );
			echo'</li>';
		} elseif ( isset( $_GET[ 'paged' ] ) && !empty( $_GET[ 'paged' ] ) ) {
			echo "<li>" . esc_html__( 'Blogs', 'vinkmag' );
			echo'</li>';
		} elseif ( is_search() ) {
			echo"<li>" . esc_html__( 'Search Result', 'vinkmag' );
			echo'</li>';
		} elseif ( is_404() ) {
			echo"<li>" . esc_html__( '404 Not Found', 'vinkmag' );
			echo'</li>';
		}
		echo '</ol>';
	}
    
endif;