<?php

function vinkmag_filter_fw_ext_backups_demos( $demos ) {
	$demo_content_installer	 = 'https://wp.xpeedstudio.com/demo-content/vinkmag';
	$demos_array			 = array(
		'demo'			 => array(
			'title'			 => esc_html__( 'Default (1-10 styles together)', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/demo/screenshot.png',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'sports'			 => array(
			'title'			 => esc_html__( 'Sports', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/sports/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'crypto'			 => array(
			'title'			 => esc_html__( 'Crypto', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/crypto/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'foods'			 => array(
			'title'			 => esc_html__( 'Foods', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/foods/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'health'			 => array(
			'title'			 => esc_html__( 'Health', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/health/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'technology'			 => array(
			'title'			 => esc_html__( 'Technology', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/technology/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'travel'			 => array(
			'title'			 => esc_html__( 'Travel', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/travel/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'business'			 => array(
			'title'			 => esc_html__( 'Business', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/business/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'personal-blog'		 => array(
			'title'			 => esc_html__( 'Personal Blog', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/personal-blog/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'times'		 => array(
			'title'			 => esc_html__( 'Vink Times', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/times/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),
		'news'		 => array(
			'title'			 => esc_html__( 'Vink News', 'vinkmag' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/news/screenshot.jpg',
			'preview_link'	 => esc_url( 'http://themeforest.net/user/xpeedstudio/portfolio' ),
		),

	);
	$download_url			 = esc_url( $demo_content_installer ) . '/manifest.php';
	foreach ( $demos_array as $id => $data ) {
		$demo						 = new FW_Ext_Backups_Demo( $id, 'piecemeal', array(
			'url'		 => $download_url,
			'file_id'	 => $id,
		) );
		$demo->set_title( $data[ 'title' ] );
		$demo->set_screenshot( $data[ 'screenshot' ] );
		$demo->set_preview_link( $data[ 'preview_link' ] );
		$demos[ $demo->get_id() ]	 = $demo;
		unset( $demo );
	}
	return $demos;
}


add_filter( 'fw:ext:backups-demo:demos', 'vinkmag_filter_fw_ext_backups_demos' );