<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * register required plugins
 */

function vinkmag_action_register_required_plugins() {
	$plugins	 = array(
		array(
			'name'		 => esc_html__( 'Unyson', 'vinkmag' ),
			'slug'		 => 'unyson',
			'required'	 => true,
		),
		array(
			'name'		 => esc_html__( 'Vinkmag Essentials', 'vinkmag' ),
			'slug'		 => 'vinkmag-essential',
			'required'	 => true,
			'version'	 => '1.2',
			'source'     => get_template_directory_uri() . '/core/installation-fragments/plugins/vinkmag-essential.zip', // The plugin source.
		),
		array(
			'name'		 => esc_html__( 'Header Footer Builder', 'vinkmag' ),
			'slug'		 => 'ekit-headerfooter',
			'version'	 => '1.4',
			'required'	 => true,
			'source'     => get_template_directory_uri() . '/core/installation-fragments/plugins/ekit-headerfooter.zip', // The plugin source.
		),
		array(
			'name'		 => esc_html__( 'Mega menu', 'vinkmag' ),
			'slug'		 => 'ekit-megamenu',
			'required'	 => true,
			'version'	 => '2.4.1',
			'source'     => get_template_directory_uri() . '/core/installation-fragments/plugins/ekit-megamenu.zip', // The plugin source.
		), 
		array(
			'name'		 => esc_html__( 'Elementor', 'vinkmag' ),
			'slug'		 => 'elementor',
			'required'	 => true,
		),		
		array(
			'name'		 => esc_html__( 'Social counter', 'vinkmag' ),
			'slug'		 => 'accesspress-social-counter',
			'required'	 => true,
		),		
		array(
			'name'		 => esc_html__( 'Mainchimp for WP', 'vinkmag' ),
			'slug'		 => 'mailchimp-for-wp',
			'required'	 => true,
		),		
		array(
			'name'		 => esc_html__( 'Easy Forms for MailChimp', 'vinkmag' ),
			'slug'		 => 'yikes-inc-easy-mailchimp-extender',
			'required'	 => true,
		),		
	);


	$config = array(
		'id'			 => 'vinkmag', // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path'	 => '', // Default absolute path to bundled plugins.
		'menu'			 => 'vinkmag-install-plugins', // Menu slug.
		'parent_slug'	 => 'themes.php', // Parent menu slug.
		'capability'	 => 'edit_theme_options', // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'	 => true, // Show admin notices or not.
		'dismissable'	 => true, // If false, a user cannot dismiss the nag message.
		'dismiss_msg'	 => '', // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic'	 => true, // Automatically activate plugins after installation or not.
		'message'		 => '', // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'vinkmag_action_register_required_plugins' );