<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * hooks for wp blog part
 */

// body class filter
// ----------------------------------------------------------------------------------------

function vinkmag_body_classes( $classes ) {
	$box_shadow_class = (vinkmag_option('style_box_shadow', 'yes') == 'yes') 
	? 'box-shadow-enebled' : 'box-shadow-disabled';

	if(is_category()){
	$category = get_category( get_query_var( 'cat' ) );
	$box_shadow_class = (vinkmag_term_option($category->cat_ID, 'style_box_shadow', 'yes') == 'yes') 
			? 'box-shadow-enebled' : 'box-shadow-disabled';
	}

	$classes[] = 'body-inner-content ' . $box_shadow_class;


	if ( is_active_sidebar( 'sidebar-right' ) || ( class_exists( 'Woocommerce' ) && ! is_woocommerce() ) || class_exists( 'Woocommerce' ) && is_woocommerce() && is_active_sidebar( 'shop-sidebar' ) ) {
		$classes[] = 'sidebar-active';
	}else{
		$classes[] = 'sidebar-inactive';
	}


    return $classes;
}
add_filter( 'body_class','vinkmag_body_classes' );



// if there is no excerpt, sets a defult placeholder
// ----------------------------------------------------------------------------------------

function vinkmag_excerpt( $words = 20, $more = null) {
	$excerpt		 = get_the_excerpt();
	echo wp_trim_words( $excerpt, $words, $more );
}

function vinkmag_desc_limit($default){
	if(!is_single() && !is_page()){
		$default_options = [
			'block_crop_desc_switch' => 'no',
			'yes' => [
				'block_crop_desc_limit' => 35
			]
		];
		$category = get_category( get_query_var( 'cat' ) );
		if(isset($category->cat_ID)){
			$limit_options = vinkmag_term_option($category->cat_ID, 'block_crop_desc', $default_options);
		}else{
			$limit_options = vinkmag_option('block_crop_desc', $default_options);
		}
		
		if($limit_options['block_crop_desc_switch'] == 'yes'){
			return $limit_options['yes']['block_crop_desc_limit'];
		}else{
			return $default;
		}
	}else{
		return $default;
	}
}

// default read more text
// ----------------------------------------------------------------------------------------
function vinkmag_excerpt_more( $more ) {
    return '...';
}
add_filter( 'excerpt_more', 'vinkmag_excerpt_more' );


function vinkmag_track_post_views ($post_id) {
	if(vinkmag_option('blog_view_count_show', 'yes') == 'yes'){
		if ( !is_single() ) return;
		if ( empty ( $post_id) ) {
			global $post;
			$post_id = $post->ID;    
		}
		vinkmag_set_postview($post_id);
	}
}
add_action( 'wp_head', 'vinkmag_track_post_views');

// change textarea position in comment form
// ----------------------------------------------------------------------------------------
function vinkmag_filter_move_comment_textarea_to_bottom( $fields ) {
	$comment_field		 = $fields[ 'comment' ];
	unset( $fields[ 'comment' ] );
	$fields[ 'comment' ] = $comment_field;
	return $fields;
}
add_filter( 'comment_form_fields', 'vinkmag_filter_move_comment_textarea_to_bottom' );


// change textarea position in comment form
// ----------------------------------------------------------------------------------------
function vinkmag_filter_search_form( $form ) {
	$form = '
	<form  method="get" action="' . esc_url( home_url( '/' ) ) . '" class="vinkmag-serach">
		<div class="input-group">
			<input class="form-control text-center" type="search" name="s" placeholder="' .esc_attr__( 'Type and hit ENTER', 'vinkmag' ) . '" value="' . get_search_query() . '">
			<div class="input-group-append">
				<span class="nav-search-close-button header-search-btn-toggle d-none" tabindex="0">✕</span>
			</div>
		</div>
	</form>
	';
	return $form;
}
add_filter( 'get_search_form', 'vinkmag_filter_search_form' );
