<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * dynamic css, generated by customizer options
 */

// display meta information for a specific post
// ----------------------------------------------------------------------------------------
function vinkmag_ad($key, $default){
	$ad = vinkmag_option($key, ['ad_link' => '', 'ad_html' => '']);
	if($ad['ad_link'] != '' || $ad['ad_link'] != ''){
		if($ad['ad_html'] != ''){
			echo vinkmag_return($ad['ad_html']);
		}else{
			?>
			<a href="<?php echo esc_url($ad['ad_link']); ?>">
				<img class="img-fluid" src="<?php echo esc_url($ad['ad_image']['url']); ?>" alt="<?php echo esc_attr('vinkmag ads', 'vinkmag'); ?>">
			</a>
			<?php
		}
	}
}


// display weather meta
// ----------------------------------------------------------------------------------------
function vinkmag_weather(){

?>
<span>25.8
	<b>c</b>
</span>
<span>Dubai</span>
<?php
}


// return breaking news query
// ----------------------------------------------------------------------------------------
function vinkmag_breaking_news_query(){
	// WP_Query arguments
	$args = array(
		'post_type'              => array( 'post' ),
		'meta_query'             => array(
			array(
				'key'     => 'fw_options',
				'value'   => '"breaking_news";s:3:"yes"',
				'compare' => 'like'
			)
		),
	);

	// The Query
	return new WP_Query( $args );
}

// display meta information for a specific post
// ----------------------------------------------------------------------------------------
function vinkmag_post_meta() {
?>
	<div class="post-meta">
	<?php 
		printf(
			'<span class="post-author">%1$s<a href="%2$s">%3$s</a></span>',
			get_avatar( get_the_author_meta( 'ID' ), 55 ), 
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), 
			get_the_author()
		);
		$category_list = get_the_category_list( ', ' );
		if ( $category_list ) {
			echo '<span class="meta-categories post-cat">
					<i class="icon icon-folder2"> </i>
					'. $category_list .' 
				 </span>';
		}
		if ( get_post_type() === 'post' ) {
			echo '<span class="post-meta-date">
					<i class="icon icon-calendar-1"></i> 
					'. get_the_date() . 
				 '</span>';
		} 
	?>
	</div>
<?php }


// display meta date for a specific post
// ----------------------------------------------------------------------------------------
function vinkmag_post_meta_date() {
	if ( get_post_type() === 'post' ) {

		echo '<span class="post-meta-date meta-date">
				<span class="day">'. get_the_date( 'm' ) . '</span>
				'. get_the_date( 'M' ) . 
			 '</span>';
	}
}


// display post share buttons
// ----------------------------------------------------------------------------------------
function vinkmag_post_share() {
	$show_share = vinkmag_option('blog_social_share', 'yes');
	if($show_share == 'yes'): ?>
		<div class="vinkmag-social-share-container">
			<ul class="social-list version-2">
				<li class="title"><?php esc_html_e('Share :','vinkmag');?></li>

				<li><a class="facebook" 
					href="<?php esc_url( 'https://www.facebook.com/share.php?u=' . the_permalink());?>"
					><i class="fa fa-facebook"></i></a></li>

				<li><a class="twitter" 
					href="<?php esc_url( 'http://twitter.com/intent/tweet?status=' . the_title() . '+' . the_permalink());?>"
					><i class="fa fa-twitter"></i></a></li>

				<li><a class="linkedin" 
					href="<?php esc_url('http://www.linkedin.com/shareArticle?mini=true&url=' . the_permalink() . '&title=' . the_title() . '&source=' . home_url('/'));?>"
					><i class="fa fa-linkedin"></i></a></li>

				<li><a class="vimeo" 
					href="<?php esc_url( 'http://pinterest.com/pin/create/bookmarklet/?url=' . the_permalink() . '&is_video=false&description=' . the_title());?>"
					><i class="fa fa-pinterest-p"></i></a></li>

				<li><a class="googlePlus" 
					href="<?php esc_url('https://plus.google.com/share?url=' . the_permalink());?>"
					><i class="fa fa-google-plus"></i></a></li>
			</ul>
		</div>
	<?php endif;
}

// display post tags
// ----------------------------------------------------------------------------------------
function vinkmag_post_tags() {
	$tag_list = get_the_tag_list( '', ' ' );
	if ( $tag_list ) {
		echo '<div class="vinkmag-tag-container">';
			echo '<h4>' . esc_html__( 'Tags: ', 'vinkmag' ) . '</h4>';
			echo '<div class="tag-lists">';
				echo vinkmag_kses( $tag_list );
			echo '</div>';
		echo '</div>';
	}
}


// comment walker
// ----------------------------------------------------------------------------------------
function vinkmag_comment_style( $comment, $args, $depth ) {
	if ( 'div' === $args[ 'style' ] ) {
		$tag		 = 'div';
		$add_below	 = 'comment';
	} else {
		$tag		 = 'li ';
		$add_below	 = 'div-comment';
	}
	?>
	<?php
	if ( $args[ 'avatar_size' ] != 0 ) {
		echo get_avatar( $comment, $args[ 'avatar_size' ], '', '', array( 'class' => 'comment-avatar pull-left' ) );
	}
	?>
	<<?php
	echo vinkmag_kses( $tag );
	comment_class( empty( $args[ 'has_children' ] ) ? '' : 'parent'  );
	?> id="comment-<?php comment_ID() ?>"><?php if ( 'div' != $args[ 'style' ] ) { ?>
		<div id="div-comment-<?php comment_ID() ?>" class="comment-body"><?php }
	?>	
		<div class="meta-data">

			<div class="pull-right reply"><?php
				comment_reply_link(
				array_merge(
				$args, array(
					'add_below'	 => $add_below,
					'depth'		 => $depth,
					'max_depth'	 => $args[ 'max_depth' ]
				) ) );
				?>
			</div>


			<span class="comment-author vcard"><?php
				printf( vinkmag_kses( '<cite class="fn">%s</cite> <span class="says">%s</span>', 'vinkmag' ), get_comment_author_link(), esc_html__( 'says:', 'vinkmag' ) );
				?>
			</span>
			<?php if ( $comment->comment_approved == '0' ) { ?>
				<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'vinkmag' ); ?></em><br/><?php }
			?>

			<div class="comment-meta commentmetadata comment-date">
				<?php
				// translators: 1: date, 2: time
				printf(
				esc_html__( '%1$s at %2$s', 'vinkmag' ), get_comment_date(), get_comment_time()
				);
				?>
				<?php edit_comment_link( esc_html__( '(Edit)', 'vinkmag' ), '  ', '' ); ?>
			</div>
		</div>	
		<div class="comment-content">
			<?php comment_text(); ?>
		</div>
		<?php if ( 'div' != $args[ 'style' ] ) : ?>
		</div><?php
	endif;
}


// pagination within pages or posts if it has a long content
// ----------------------------------------------------------------------------------------
function vinkmag_link_pages() {
	$args = array(
		'before'			 => '<div class="page-links"><span class="page-link-text">' . esc_html__( 'More pages: ', 'vinkmag' ) . '</span>',
		'after'				 => '</div>',
		'link_before'		 => '<span class="page-link">',
		'link_after'		 => '</span>',
		'next_or_number'	 => 'number',
		'separator'			 => '  ',
		'nextpagelink'		 => esc_html__( 'Next ', 'vinkmag' ) . '<I class="fa fa-angle-right"></i>',
		'previouspagelink'	 => '<I class="fa fa-angle-left"></i>' . esc_html__( ' Previous', 'vinkmag' ),
	);
	wp_link_pages( $args );
}
