<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * helper functions
 */

// simply echo the variable
// ----------------------------------------------------------------------------------------
function vinkmag_return( $s ) {
	return $s;
}


// limit title
// ----------------------------------------------------------------------------------------
function vinkmag_limited_title( $title, $max = 20, $tail = '...' ) {
	return wp_trim_words($title, $max, $tail);
}


// return the specific value from theme options/ customizer/ etc
// ----------------------------------------------------------------------------------------
function vinkmag_option( $key, $default_value = '', $meta_option_first = false, $method = 'customizer' ) {
	if ( defined( 'FW' ) ) {
		switch ( $method ) {
			case 'theme-settings':
				$value = fw_get_db_settings_option( $key );
				break;
			case 'customizer':
				$value = fw_get_db_customizer_option( $key );
				break;
			default:
				$value = '';
				break;
		}
		if($meta_option_first == true && defined('VINKMAG_DEMO')){
			return vinkmag_post_option( get_the_ID(), $key, $default_value);
		}
		return (!isset($value) || $value == '') ? $default_value :  $value;
	}
	return $default_value;
}


// return the specific value from post metabox
// ----------------------------------------------------------------------------------------
function vinkmag_post_option( $postid, $key, $default_value = '') {
	if ( defined( 'FW' ) ) {
		$value = fw_get_db_post_option($postid, $key, $default_value);
	}
	return (!isset($value) || $value == '') ? $default_value :  $value;
}


// return the specific value from term/ taxomony metabox
// ----------------------------------------------------------------------------------------
function vinkmag_term_option( $termid, $key, $default_value = '', $taxomony = 'category', $return_org = false ) {
	if ( defined( 'FW' ) ) {
		$value = fw_get_db_term_option($termid, $taxomony, $key);
		$override = fw_get_db_term_option($termid, $taxomony, 'override_default');
		if(($return_org == false && defined('VINKMAG_DEMO')) && ($override != 'yes' || empty($value))){
			$value = vinkmag_option($key, $default_value);
		}
	}
	return (!isset($value) || $value == '') ? $default_value :  $value;
}


// return the specific category
// ----------------------------------------------------------------------------------------
function vinkmag_cat_style( $termid, $css = null) {
	$bg = 	vinkmag_term_option($termid, 'block_highlight_color', 
				vinkmag_option('style_primary', '#d72924'), 'category', true
			);
	$co = 	vinkmag_term_option($termid, 'block_secondary_color', '#ffffff', 'category', true);

	if($css == 'color_only'){
		return 'color:'.$bg;
	}else{
		return 'color:'.$co.'; background-color:' . $bg . '; border-left-color:' . $bg;
	}
}


// post view count
// ----------------------------------------------------------------------------------------
// function to display number of posts.
function vinkmag_get_postview($postID){
    $count_key = 'vinkmag_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        return "0";
    }
    return $count;
}

// function to count views.
function vinkmag_set_postview($postID) {
    $count_key = 'vinkmag_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}


// extract unyson image data from option value in a much simple way
// ----------------------------------------------------------------------------------------
function vinkmag_src( $key, $default_value = '', $input_as_attachment = false ) { // for src
	if ( $input_as_attachment == true ) {
		$attachment = $key;
	} else {
		$attachment = vinkmag_option( $key );
	}

	if ( isset( $attachment[ 'url' ] ) && !empty( $attachment ) ) {
		return $attachment[ 'url' ];
	}

	return $default_value;
}


// unyson based image resizer
// ----------------------------------------------------------------------------------------
function vinkmag_resize( $url, $width = false, $height = false, $crop = false ) {
	if ( function_exists( 'fw_resize' ) ) {
		return fw_resize( $url, $width, $height, $crop );
	} else {
		return $url;
	}
}


// return safe thumbnail
// ----------------------------------------------------------------------------------------
function vinkmag_post_thumbnail($postID = null, $w = 455, $h = 300){
	$src = VINKMAG_IMG . '/default_thumb.jpg';
	if(has_post_thumbnail($postID) && !post_password_required($postID)){
		$src = get_the_post_thumbnail_url($postID, 'full');

		if($w == 'full'){
			return $src;
		}

		$src = vinkmag_resize($src, $w, $h, true);
	}
	return $src;
}

// return attachment alt in safe mode
// ----------------------------------------------------------------------------------------
function vinkmag_alt( $id ) {
	if ( !empty( $id ) ) {
		$alt = get_post_meta( $id, '_wp_attachment_image_alt', true );
		if ( !empty( $alt ) ) {
			$alt = $alt;
		} else {
			$alt = get_the_title( $id );
		}
		return $alt;
	}
}


// get original id in WPML enabled WP
// ----------------------------------------------------------------------------------------
function vinkmag_org_id( $id, $name = true ) {
	if ( function_exists( 'icl_object_id' ) ) {
		$id = icl_object_id( $id, 'page', true, 'en' );
	}

	if ( $name === true ) {
		$post = get_post( $id );
		return $post->post_name;
	} else {
		return $id;
	}
}


// converts rgb color code to hex format
// ----------------------------------------------------------------------------------------
function vinkmag_rgb2hex( $hex ) {
	$hex		 = preg_replace( "/^#(.*)$/", "$1", $hex );
	$rgb		 = array();
	$rgb[ 'r' ]	 = hexdec( substr( $hex, 0, 2 ) );
	$rgb[ 'g' ]	 = hexdec( substr( $hex, 2, 2 ) );
	$rgb[ 'b' ]	 = hexdec( substr( $hex, 4, 2 ) );

	$color_hex = $rgb[ "r" ] . ", " . $rgb[ "g" ] . ", " . $rgb[ "b" ];
	return $color_hex;
}


// WP kses allowed tags
// ----------------------------------------------------------------------------------------
function vinkmag_kses( $raw ) {

	$allowed_tags = array(
		'a'								 => array(
			'class'	 => array(),
			'href'	 => array(),
			'rel'	 => array(),
			'title'	 => array(),
		),
		'abbr'							 => array(
			'title' => array(),
		),
		'b'								 => array(),
		'blockquote'					 => array(
			'cite' => array(),
		),
		'cite'							 => array(
			'title' => array(),
		),
		'code'							 => array(),
		'del'							 => array(
			'datetime'	 => array(),
			'title'		 => array(),
		),
		'dd'							 => array(),
		'div'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'dl'							 => array(),
		'dt'							 => array(),
		'em'							 => array(),
		'h1'							 => array(),
		'h2'							 => array(),
		'h3'							 => array(),
		'h4'							 => array(),
		'h5'							 => array(),
		'h6'							 => array(),
		'i'								 => array(
			'class' => array(),
		),
		'img'							 => array(
			'alt'	 => array(),
			'class'	 => array(),
			'height' => array(),
			'src'	 => array(),
			'width'	 => array(),
		),
		'li'							 => array(
			'class' => array(),
		),
		'ol'							 => array(
			'class' => array(),
		),
		'p'								 => array(
			'class' => array(),
		),
		'q'								 => array(
			'cite'	 => array(),
			'title'	 => array(),
		),
		'span'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'iframe'						 => array(
			'width'			 => array(),
			'height'		 => array(),
			'scrolling'		 => array(),
			'frameborder'	 => array(),
			'allow'			 => array(),
			'src'			 => array(),
		),
		'strike'						 => array(),
		'br'							 => array(),
		'strong'						 => array(),
		'data-wow-duration'				 => array(),
		'data-wow-delay'				 => array(),
		'data-wallpaper-options'		 => array(),
		'data-stellar-background-ratio'	 => array(),
		'ul'							 => array(
			'class' => array(),
		),
	);

	if ( function_exists( 'wp_kses' ) ) { // WP is here
		$allowed = wp_kses( $raw, $allowed_tags );
	} else {
		$allowed = $raw;
	}


	return $allowed;
}


// build google font url
// ----------------------------------------------------------------------------------------
function vinkmag_google_fonts_url($font_families	 = []) {
	$fonts_url		 = '';
	if ( $font_families ) {
		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) )
		);

		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );
}


// return cover image from an youtube video url
// ----------------------------------------------------------------------------------------
function vinkmag_youtube_cover( $e ) {
	$src = null;
	//get the url
	if ( $e != '' ){
		$url = $e;
		$queryString = parse_url( $url, PHP_URL_QUERY );
		parse_str( $queryString, $params );

		//generate the src
		if ( isset($params[ 'v' ]) && strlen($params[ 'v' ]) > 0 ) {
			$src = "http://i3.ytimg.com/vi/$v/default.jpg";
		}
	}

	return $src;
}


// return embed code for sound cloud
// ----------------------------------------------------------------------------------------
function vinkmag_soundcloud_embed( $url ) {
	return 'https://w.soundcloud.com/player/?url=' . urlencode($url) . '&auto_play=false&color=915f33&theme_color=00FF00';
}


// return embed code video url
// ----------------------------------------------------------------------------------------
function vinkmag_video_embed($url){
    //This is a general function for generating an embed link of an FB/Vimeo/Youtube Video.
	$embed_url = '';
    if(strpos($url, 'facebook.com/') !== false) {
        //it is FB video
        $embed_url ='https://www.facebook.com/plugins/video.php?href='.rawurlencode($url).'&show_text=1&width=200';
    }else if(strpos($url, 'vimeo.com/') !== false) {
        //it is Vimeo video
        $video_id = explode("vimeo.com/",$url)[1];
        if(strpos($video_id, '&') !== false){
            $video_id = explode("&",$video_id)[0];
        }
        $embed_url ='https://player.vimeo.com/video/'.$video_id;
    }else if(strpos($url, 'youtube.com/') !== false) {
        //it is Youtube video
        $video_id = explode("v=",$url)[1];
        if(strpos($video_id, '&') !== false){
            $video_id = explode("&",$video_id)[0];
        }
		$embed_url ='https://www.youtube.com/embed/'.$video_id;
    }else if(strpos($url, 'youtu.be/') !== false){
        //it is Youtube video
        $video_id = explode("youtu.be/",$url)[1];
        if(strpos($video_id, '&') !== false){
            $video_id = explode("&",$video_id)[0];
        }
        $embed_url ='https://www.youtube.com/embed/'.$video_id;
    }else{
        //for new valid video URL
    }
    return $embed_url;
}


// advanced fonts rendaring
// ----------------------------------------------------------------------------------------
if ( !function_exists( 'vinkmag_advanced_font_styles' ) ) :
	function vinkmag_advanced_font_styles( $style, $property = null ) {
		$font_styles = '';
		if ( isset( $style[ 'google_font' ] ) && ($style[ 'google_font' ] === true || $style[ 'google_font' ] === 'true') ) {

			$font_styles .= (isset( $style[ 'family' ] ) && ($property === null || $property == 'font-family') ) ? 'font-family:"' . $style[ 'family' ] . '";' : '';

			if($property === null || $property == 'font-style') {
			if ( strpos( $style[ 'variation' ], 'italic' ) !== false )
				$font_styles .= 'font-style:italic;';
			elseif ( strpos( $style[ 'variation' ], 'oblique' ) !== false )
				$font_styles .= 'font-style: oblique;';
			else
				$font_styles .= 'font-style: normal;';

			$font_styles .= ((int) $style[ 'variation' ] === 0)
							? 'font-weight:400;' : 'font-weight:' . (int) $style[ 'variation' ] . ';';

			}
		} else {
			$font_styles .= (isset( $style[ 'family' ] ) && ($property === null || $property == 'font-family') )
							? 'font-family:"' . $style[ 'family' ] . '";' : '';
			$font_styles .= (isset( $style[ 'style' ] ) && ($property === null || $property == 'font-style') )
							? 'font-style:' . esc_attr( $style[ 'style' ] ) . ';' : '';
			$font_styles .= (isset( $style[ 'weight' ] ) && ($property === null || $property == 'font-weight') )
							? 'font-weight:' . esc_attr( $style[ 'weight' ] ) . ';' : '';
		}
		$font_styles .= (isset( $style[ 'color' ] ) && !empty( $style[ 'color' ] ) && ($property == null || $property == 'color') )
						? 'color:' . esc_attr( $style[ 'color' ] ) . ';' : '';

		$font_styles .= (isset( $style[ 'line-height' ] ) && !empty( $style[ 'line-height' ] )  && ($property == null || $property == 'line-height'))
						? 'line-height:' . esc_attr( $style[ 'line-height' ] ) . 'px;' : '';

		$font_styles .= (isset( $style[ 'letter-spacing' ] ) && !empty( $style[ 'letter-spacing' ] ) && ($property == null || $property == 'letter-spacing') )
						? 'letter-spacing:' . esc_attr( $style[ 'letter-spacing' ] ) . 'px;' : '';

		$font_styles .= (isset( $style[ 'size' ] ) && !empty( $style[ 'size' ] ) && ($property == null || $property == 'font-size') )
						? 'font-size:' . esc_attr( $style[ 'size' ] ) . 'px;' : '';


		return !empty( $font_styles ) ? $font_styles : '';
	}

endif;


// social sharing buttons
// ----------------------------------------------------------------------------------------
function vinkmag_social_share(){
	?>
	<ul class="social-list version-2">
		
		<li><a class="facebook" href="http://www.facebook.com/share.php?u=<?php esc_url(the_permalink());?>title=<?php esc_url(the_title());?>"><i class="fa fa-facebook"></i></a></li>
		<li><a class="twitter" href="http://twitter.com/intent/tweet?status=<?php esc_url(the_title());?>+<?php esc_url(the_permalink());?>"><i class="fa fa-twitter"></i></a></li>
		<li><a class="linkedin" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php esc_url(the_permalink());?>&amp;title=<?php esc_url(the_title());?>&amp;source=<?php echo esc_url(home_url('/'));?>"><i class="fa fa-linkedin"></i></a></li>
		<li><a class="vimeo" href="http://pinterest.com/pin/create/bookmarklet/?url=<?php esc_url(the_permalink());?>&amp;is_video=false&amp;description=<?php esc_url(the_title());?>"><i class="fa fa-pinterest-p"></i></a></li>
		<li><a class="googlePlus" href="https://plus.google.com/share?url=<?php esc_url(the_permalink());?>"><i class="fa fa-google-plus"></i></a></li>
	</ul>
	<?php
}


// read time by word count
// ----------------------------------------------------------------------------------------
function vinkmag_count_read_time(){
	$word = str_word_count(strip_tags(get_the_content()));
    $time = "<i class='fa fa-eye'></i>". ceil( $word / 200 ) . esc_html(' minutes read', 'vinkmag');
    return $time; // in minutes
}