<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * enqueue all theme scripts and styles
 */


// stylesheets
// ----------------------------------------------------------------------------------------
if ( !is_admin() ) {
	// wp_enqueue_style() $handle, $src, $deps, $version

	// 3rd party css
	wp_enqueue_style( 'vinkmag-fonts', vinkmag_google_fonts_url(['Arimo:400,400i,700,700i', 'Heebo:400,500,700,800,900', 'Merriweather:400,400i,700,700i,900,900i']), null, VINKMAG_VERSION );

		wp_enqueue_style( 'bootstrap', VINKMAG_CSS . '/bootstrap.min.css', null, VINKMAG_VERSION );

	wp_style_add_data( 'bootstrap', 'rtl', 'replace' );
	wp_enqueue_style( 'font-awesome', VINKMAG_CSS . '/font-awesome.min.css', null, VINKMAG_VERSION );
	wp_enqueue_style( 'animate', VINKMAG_CSS . '/animate.css', null, VINKMAG_VERSION );
	wp_enqueue_style( 'icofonts', VINKMAG_CSS . '/icofonts.css', null, VINKMAG_VERSION );
	wp_enqueue_style( 'owlcarousel', VINKMAG_CSS . '/owlcarousel.min.css', null, VINKMAG_VERSION );
	wp_enqueue_style( 'slick', VINKMAG_CSS . '/slick.css', null, VINKMAG_VERSION );
	wp_enqueue_style( 'jquery-mCustomScrollbar', VINKMAG_CSS . '/jquery.mCustomScrollbar.css', null, VINKMAG_VERSION );
	wp_enqueue_style( 'magnific-popup', VINKMAG_CSS . '/magnific-popup.css', null, VINKMAG_VERSION );

	// theme css
	wp_enqueue_style( 'vinkmag-style', VINKMAG_CSS . '/style.css', null, VINKMAG_VERSION );
	wp_enqueue_style( 'vinkmag-blog', VINKMAG_CSS . '/blog.css', null, VINKMAG_VERSION );
	wp_enqueue_style( 'vinkmag-responsive', VINKMAG_CSS . '/responsive.css', null, VINKMAG_VERSION );
	wp_enqueue_style( 'vinkmag-gutenberg', VINKMAG_CSS . '/gutenberg.css', null, VINKMAG_VERSION );
	if ( is_rtl() ) {
		wp_enqueue_style( 'vinkmag-rtl', VINKMAG_THEME_URI . '/rtl.css', null, VINKMAG_VERSION );
	}
}

// javascripts
// ----------------------------------------------------------------------------------------
if ( !is_admin() ) {
	// wp_enqueue_script() $handle, $src, $deps, $version, $in_footer(boolean)

	// 3rd party scripts
	wp_enqueue_script( 'popper', VINKMAG_JS . '/popper.min.js', array( 'jquery' ), VINKMAG_VERSION, true );
	if ( is_rtl() ) {
		wp_enqueue_script( 'bootstrap-js', VINKMAG_JS . '/bootstrap.min-rtl.js', array( 'jquery' ), VINKMAG_VERSION, true );
	} else {
		wp_enqueue_script( 'bootstrap-js', VINKMAG_JS . '/bootstrap.min.js', array( 'jquery' ), VINKMAG_VERSION, true );
	}
	wp_enqueue_script( 'magnific-popup', VINKMAG_JS . '/jquery.magnific-popup.min.js', array( 'jquery' ), VINKMAG_VERSION, true );
	wp_enqueue_script( 'owl-carousel', VINKMAG_JS . '/owl-carousel.2.3.0.min.js', array( 'jquery' ), VINKMAG_VERSION, true );
	wp_enqueue_script( 'slick', VINKMAG_JS . '/slick.min.js', array( 'jquery' ), VINKMAG_VERSION, true );
	wp_enqueue_script( 'echo', VINKMAG_JS . '/echo.min.js', array( 'jquery' ), VINKMAG_VERSION, true );
	wp_enqueue_script( 'instafeed', VINKMAG_JS . '/instafeed.min.js', array( 'jquery' ), VINKMAG_VERSION, true );
	wp_enqueue_script( 'jquery-mCustomScrollbar-concat', VINKMAG_JS . '/jquery.mCustomScrollbar.concat.min.js', array( 'jquery' ), VINKMAG_VERSION, true );

	// theme scripts
	wp_enqueue_script( 'vinkmag-script', VINKMAG_JS . '/script.js', array( 'jquery' ), VINKMAG_VERSION, true );
	
	// Load WordPress Comment js
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}